@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.servicefabric.kotlin.inputs

import com.pulumi.azurenative.servicefabric.inputs.GetManagedClusterPlainArgs.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property clusterName The name of the cluster resource.
 * @property resourceGroupName The name of the resource group.
 */
public data class GetManagedClusterPlainArgs(
    public val clusterName: String,
    public val resourceGroupName: String,
) : ConvertibleToJava<com.pulumi.azurenative.servicefabric.inputs.GetManagedClusterPlainArgs> {
    override fun toJava(): com.pulumi.azurenative.servicefabric.inputs.GetManagedClusterPlainArgs =
        com.pulumi.azurenative.servicefabric.inputs.GetManagedClusterPlainArgs.builder()
            .clusterName(clusterName.let({ args0 -> args0 }))
            .resourceGroupName(resourceGroupName.let({ args0 -> args0 })).build()
}

/**
 * Builder for [GetManagedClusterPlainArgs].
 */
@PulumiTagMarker
public class GetManagedClusterPlainArgsBuilder internal constructor() {
    private var clusterName: String? = null

    private var resourceGroupName: String? = null

    /**
     * @param value The name of the cluster resource.
     */
    @JvmName("jwroomhgthmikwrf")
    public suspend fun clusterName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.clusterName = mapped
    }

    /**
     * @param value The name of the resource group.
     */
    @JvmName("vorxjgwmuomuaiuw")
    public suspend fun resourceGroupName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.resourceGroupName = mapped
    }

    internal fun build(): GetManagedClusterPlainArgs = GetManagedClusterPlainArgs(
        clusterName = clusterName ?: throw PulumiNullFieldException("clusterName"),
        resourceGroupName = resourceGroupName ?: throw PulumiNullFieldException("resourceGroupName"),
    )
}
