@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.servicefabric.kotlin.inputs

import com.pulumi.azurenative.servicefabric.inputs.GetManagedClusterServicePlainArgs.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property applicationName The name of the application resource.
 * @property clusterName The name of the cluster resource.
 * @property resourceGroupName The name of the resource group.
 * @property serviceName The name of the service resource in the format of {applicationName}~{serviceName}.
 */
public data class GetManagedClusterServicePlainArgs(
    public val applicationName: String,
    public val clusterName: String,
    public val resourceGroupName: String,
    public val serviceName: String,
) : ConvertibleToJava<com.pulumi.azurenative.servicefabric.inputs.GetManagedClusterServicePlainArgs> {
    override fun toJava(): com.pulumi.azurenative.servicefabric.inputs.GetManagedClusterServicePlainArgs =
        com.pulumi.azurenative.servicefabric.inputs.GetManagedClusterServicePlainArgs.builder()
            .applicationName(applicationName.let({ args0 -> args0 }))
            .clusterName(clusterName.let({ args0 -> args0 }))
            .resourceGroupName(resourceGroupName.let({ args0 -> args0 }))
            .serviceName(serviceName.let({ args0 -> args0 })).build()
}

/**
 * Builder for [GetManagedClusterServicePlainArgs].
 */
@PulumiTagMarker
public class GetManagedClusterServicePlainArgsBuilder internal constructor() {
    private var applicationName: String? = null

    private var clusterName: String? = null

    private var resourceGroupName: String? = null

    private var serviceName: String? = null

    /**
     * @param value The name of the application resource.
     */
    @JvmName("krutkksmeyvcosiv")
    public suspend fun applicationName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.applicationName = mapped
    }

    /**
     * @param value The name of the cluster resource.
     */
    @JvmName("ahjhdkaxvtkfdutx")
    public suspend fun clusterName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.clusterName = mapped
    }

    /**
     * @param value The name of the resource group.
     */
    @JvmName("jmrovcbofkpwlpxt")
    public suspend fun resourceGroupName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.resourceGroupName = mapped
    }

    /**
     * @param value The name of the service resource in the format of {applicationName}~{serviceName}.
     */
    @JvmName("godfvqckqfsxjola")
    public suspend fun serviceName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.serviceName = mapped
    }

    internal fun build(): GetManagedClusterServicePlainArgs = GetManagedClusterServicePlainArgs(
        applicationName = applicationName ?: throw PulumiNullFieldException("applicationName"),
        clusterName = clusterName ?: throw PulumiNullFieldException("clusterName"),
        resourceGroupName = resourceGroupName ?: throw PulumiNullFieldException("resourceGroupName"),
        serviceName = serviceName ?: throw PulumiNullFieldException("serviceName"),
    )
}
