@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.servicefabric.kotlin.inputs

import com.pulumi.azurenative.servicefabric.inputs.GetNodeTypePlainArgs.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property clusterName The name of the cluster resource.
 * @property nodeTypeName The name of the node type.
 * @property resourceGroupName The name of the resource group.
 */
public data class GetNodeTypePlainArgs(
    public val clusterName: String,
    public val nodeTypeName: String,
    public val resourceGroupName: String,
) : ConvertibleToJava<com.pulumi.azurenative.servicefabric.inputs.GetNodeTypePlainArgs> {
    override fun toJava(): com.pulumi.azurenative.servicefabric.inputs.GetNodeTypePlainArgs =
        com.pulumi.azurenative.servicefabric.inputs.GetNodeTypePlainArgs.builder()
            .clusterName(clusterName.let({ args0 -> args0 }))
            .nodeTypeName(nodeTypeName.let({ args0 -> args0 }))
            .resourceGroupName(resourceGroupName.let({ args0 -> args0 })).build()
}

/**
 * Builder for [GetNodeTypePlainArgs].
 */
@PulumiTagMarker
public class GetNodeTypePlainArgsBuilder internal constructor() {
    private var clusterName: String? = null

    private var nodeTypeName: String? = null

    private var resourceGroupName: String? = null

    /**
     * @param value The name of the cluster resource.
     */
    @JvmName("cedglfbvuaqoydgq")
    public suspend fun clusterName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.clusterName = mapped
    }

    /**
     * @param value The name of the node type.
     */
    @JvmName("fvovboyfelfkkrhi")
    public suspend fun nodeTypeName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.nodeTypeName = mapped
    }

    /**
     * @param value The name of the resource group.
     */
    @JvmName("ycaapvgsplonyywt")
    public suspend fun resourceGroupName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.resourceGroupName = mapped
    }

    internal fun build(): GetNodeTypePlainArgs = GetNodeTypePlainArgs(
        clusterName = clusterName ?: throw PulumiNullFieldException("clusterName"),
        nodeTypeName = nodeTypeName ?: throw PulumiNullFieldException("nodeTypeName"),
        resourceGroupName = resourceGroupName ?: throw PulumiNullFieldException("resourceGroupName"),
    )
}
