@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.servicefabric.kotlin.inputs

import com.pulumi.azurenative.servicefabric.inputs.LoadBalancingRuleArgs.builder
import com.pulumi.azurenative.servicefabric.kotlin.enums.ProbeProtocol
import com.pulumi.azurenative.servicefabric.kotlin.enums.Protocol
import com.pulumi.core.Either
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * Describes a load balancing rule.
 * @property backendPort The port used for internal connections on the endpoint. Acceptable values are between 1 and 65535.
 * @property frontendPort The port for the external endpoint. Port numbers for each rule must be unique within the Load Balancer. Acceptable values are between 1 and 65534.
 * @property loadDistribution The load distribution policy for this rule.
 * @property probePort The prob port used by the load balancing rule. Acceptable values are between 1 and 65535.
 * @property probeProtocol the reference to the load balancer probe used by the load balancing rule.
 * @property probeRequestPath The probe request path. Only supported for HTTP/HTTPS probes.
 * @property protocol The reference to the transport protocol used by the load balancing rule.
 */
public data class LoadBalancingRuleArgs(
    public val backendPort: Output<Int>,
    public val frontendPort: Output<Int>,
    public val loadDistribution: Output<String>? = null,
    public val probePort: Output<Int>? = null,
    public val probeProtocol: Output<Either<String, ProbeProtocol>>,
    public val probeRequestPath: Output<String>? = null,
    public val protocol: Output<Either<String, Protocol>>,
) : ConvertibleToJava<com.pulumi.azurenative.servicefabric.inputs.LoadBalancingRuleArgs> {
    override fun toJava(): com.pulumi.azurenative.servicefabric.inputs.LoadBalancingRuleArgs =
        com.pulumi.azurenative.servicefabric.inputs.LoadBalancingRuleArgs.builder()
            .backendPort(backendPort.applyValue({ args0 -> args0 }))
            .frontendPort(frontendPort.applyValue({ args0 -> args0 }))
            .loadDistribution(loadDistribution?.applyValue({ args0 -> args0 }))
            .probePort(probePort?.applyValue({ args0 -> args0 }))
            .probeProtocol(
                probeProtocol.applyValue({ args0 ->
                    args0.transform({ args0 -> args0 }, { args0 ->
                        args0.let({ args0 -> args0.toJava() })
                    })
                }),
            )
            .probeRequestPath(probeRequestPath?.applyValue({ args0 -> args0 }))
            .protocol(
                protocol.applyValue({ args0 ->
                    args0.transform({ args0 -> args0 }, { args0 ->
                        args0.let({ args0 -> args0.toJava() })
                    })
                }),
            ).build()
}

/**
 * Builder for [LoadBalancingRuleArgs].
 */
@PulumiTagMarker
public class LoadBalancingRuleArgsBuilder internal constructor() {
    private var backendPort: Output<Int>? = null

    private var frontendPort: Output<Int>? = null

    private var loadDistribution: Output<String>? = null

    private var probePort: Output<Int>? = null

    private var probeProtocol: Output<Either<String, ProbeProtocol>>? = null

    private var probeRequestPath: Output<String>? = null

    private var protocol: Output<Either<String, Protocol>>? = null

    /**
     * @param value The port used for internal connections on the endpoint. Acceptable values are between 1 and 65535.
     */
    @JvmName("odjrjffxmpqwfgpd")
    public suspend fun backendPort(`value`: Output<Int>) {
        this.backendPort = value
    }

    /**
     * @param value The port for the external endpoint. Port numbers for each rule must be unique within the Load Balancer. Acceptable values are between 1 and 65534.
     */
    @JvmName("wushummvestksabr")
    public suspend fun frontendPort(`value`: Output<Int>) {
        this.frontendPort = value
    }

    /**
     * @param value The load distribution policy for this rule.
     */
    @JvmName("pwkvbmrrgiopmerw")
    public suspend fun loadDistribution(`value`: Output<String>) {
        this.loadDistribution = value
    }

    /**
     * @param value The prob port used by the load balancing rule. Acceptable values are between 1 and 65535.
     */
    @JvmName("acntstcypmpfpcqc")
    public suspend fun probePort(`value`: Output<Int>) {
        this.probePort = value
    }

    /**
     * @param value the reference to the load balancer probe used by the load balancing rule.
     */
    @JvmName("kxgiqougtvtipstq")
    public suspend fun probeProtocol(`value`: Output<Either<String, ProbeProtocol>>) {
        this.probeProtocol = value
    }

    /**
     * @param value The probe request path. Only supported for HTTP/HTTPS probes.
     */
    @JvmName("axmenjvfcgmnlrig")
    public suspend fun probeRequestPath(`value`: Output<String>) {
        this.probeRequestPath = value
    }

    /**
     * @param value The reference to the transport protocol used by the load balancing rule.
     */
    @JvmName("efgejodjoaraxgec")
    public suspend fun protocol(`value`: Output<Either<String, Protocol>>) {
        this.protocol = value
    }

    /**
     * @param value The port used for internal connections on the endpoint. Acceptable values are between 1 and 65535.
     */
    @JvmName("mojgqjdxxmhddbee")
    public suspend fun backendPort(`value`: Int) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.backendPort = mapped
    }

    /**
     * @param value The port for the external endpoint. Port numbers for each rule must be unique within the Load Balancer. Acceptable values are between 1 and 65534.
     */
    @JvmName("tbtcgfkqmxvckvrh")
    public suspend fun frontendPort(`value`: Int) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.frontendPort = mapped
    }

    /**
     * @param value The load distribution policy for this rule.
     */
    @JvmName("ppsjwpuvmjyiqbai")
    public suspend fun loadDistribution(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.loadDistribution = mapped
    }

    /**
     * @param value The prob port used by the load balancing rule. Acceptable values are between 1 and 65535.
     */
    @JvmName("ckpyuwdhrtmcswmo")
    public suspend fun probePort(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.probePort = mapped
    }

    /**
     * @param value the reference to the load balancer probe used by the load balancing rule.
     */
    @JvmName("spepddhliqyloliw")
    public suspend fun probeProtocol(`value`: Either<String, ProbeProtocol>) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.probeProtocol = mapped
    }

    /**
     * @param value the reference to the load balancer probe used by the load balancing rule.
     */
    @JvmName("pmmckbpynsmxkbxl")
    public fun probeProtocol(`value`: String) {
        val toBeMapped = Either.ofLeft<String, ProbeProtocol>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.probeProtocol = mapped
    }

    /**
     * @param value the reference to the load balancer probe used by the load balancing rule.
     */
    @JvmName("uekwhenolpenyahe")
    public fun probeProtocol(`value`: ProbeProtocol) {
        val toBeMapped = Either.ofRight<String, ProbeProtocol>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.probeProtocol = mapped
    }

    /**
     * @param value The probe request path. Only supported for HTTP/HTTPS probes.
     */
    @JvmName("cumsvxavvbannkya")
    public suspend fun probeRequestPath(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.probeRequestPath = mapped
    }

    /**
     * @param value The reference to the transport protocol used by the load balancing rule.
     */
    @JvmName("bpdkbgdqvdwrdhvm")
    public suspend fun protocol(`value`: Either<String, Protocol>) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.protocol = mapped
    }

    /**
     * @param value The reference to the transport protocol used by the load balancing rule.
     */
    @JvmName("pnyqpbbbhvcsbdmk")
    public fun protocol(`value`: String) {
        val toBeMapped = Either.ofLeft<String, Protocol>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.protocol = mapped
    }

    /**
     * @param value The reference to the transport protocol used by the load balancing rule.
     */
    @JvmName("luqwrxgowsfjqpyc")
    public fun protocol(`value`: Protocol) {
        val toBeMapped = Either.ofRight<String, Protocol>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.protocol = mapped
    }

    internal fun build(): LoadBalancingRuleArgs = LoadBalancingRuleArgs(
        backendPort = backendPort ?: throw PulumiNullFieldException("backendPort"),
        frontendPort = frontendPort ?: throw PulumiNullFieldException("frontendPort"),
        loadDistribution = loadDistribution,
        probePort = probePort,
        probeProtocol = probeProtocol ?: throw PulumiNullFieldException("probeProtocol"),
        probeRequestPath = probeRequestPath,
        protocol = protocol ?: throw PulumiNullFieldException("protocol"),
    )
}
