@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.servicefabric.kotlin.inputs

import com.pulumi.azurenative.servicefabric.inputs.NodeTypeSkuArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * Describes a node type sku.
 * @property capacity The number of nodes in the node type.<br /><br />If present in request it will override properties.vmInstanceCount.
 * @property name The sku name. <br /><br />Name is internally generated and is used in auto-scale scenarios.<br /> Property does not allow to be changed to other values than generated.<br /> To avoid deployment errors please omit the property.
 * @property tier Specifies the tier of the node type. <br /><br /> Possible Values:<br /> **Standard**
 */
public data class NodeTypeSkuArgs(
    public val capacity: Output<Int>,
    public val name: Output<String>? = null,
    public val tier: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.servicefabric.inputs.NodeTypeSkuArgs> {
    override fun toJava(): com.pulumi.azurenative.servicefabric.inputs.NodeTypeSkuArgs =
        com.pulumi.azurenative.servicefabric.inputs.NodeTypeSkuArgs.builder()
            .capacity(capacity.applyValue({ args0 -> args0 }))
            .name(name?.applyValue({ args0 -> args0 }))
            .tier(tier?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [NodeTypeSkuArgs].
 */
@PulumiTagMarker
public class NodeTypeSkuArgsBuilder internal constructor() {
    private var capacity: Output<Int>? = null

    private var name: Output<String>? = null

    private var tier: Output<String>? = null

    /**
     * @param value The number of nodes in the node type.<br /><br />If present in request it will override properties.vmInstanceCount.
     */
    @JvmName("tneuslgbxatyhgkd")
    public suspend fun capacity(`value`: Output<Int>) {
        this.capacity = value
    }

    /**
     * @param value The sku name. <br /><br />Name is internally generated and is used in auto-scale scenarios.<br /> Property does not allow to be changed to other values than generated.<br /> To avoid deployment errors please omit the property.
     */
    @JvmName("cvybfexpkarbxgqm")
    public suspend fun name(`value`: Output<String>) {
        this.name = value
    }

    /**
     * @param value Specifies the tier of the node type. <br /><br /> Possible Values:<br /> **Standard**
     */
    @JvmName("akhlxnedylgdrhax")
    public suspend fun tier(`value`: Output<String>) {
        this.tier = value
    }

    /**
     * @param value The number of nodes in the node type.<br /><br />If present in request it will override properties.vmInstanceCount.
     */
    @JvmName("kucwjsygpngwfujr")
    public suspend fun capacity(`value`: Int) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.capacity = mapped
    }

    /**
     * @param value The sku name. <br /><br />Name is internally generated and is used in auto-scale scenarios.<br /> Property does not allow to be changed to other values than generated.<br /> To avoid deployment errors please omit the property.
     */
    @JvmName("rgnvjfmgfpdjukdf")
    public suspend fun name(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.name = mapped
    }

    /**
     * @param value Specifies the tier of the node type. <br /><br /> Possible Values:<br /> **Standard**
     */
    @JvmName("jmvukkavwyxroxgm")
    public suspend fun tier(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.tier = mapped
    }

    internal fun build(): NodeTypeSkuArgs = NodeTypeSkuArgs(
        capacity = capacity ?: throw PulumiNullFieldException("capacity"),
        name = name,
        tier = tier,
    )
}
