@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.servicefabric.kotlin.inputs

import com.pulumi.azurenative.servicefabric.inputs.ServiceEndpointArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 * The service endpoint properties.
 * @property locations A list of locations.
 * @property service The type of the endpoint service.
 */
public data class ServiceEndpointArgs(
    public val locations: Output<List<String>>? = null,
    public val service: Output<String>,
) : ConvertibleToJava<com.pulumi.azurenative.servicefabric.inputs.ServiceEndpointArgs> {
    override fun toJava(): com.pulumi.azurenative.servicefabric.inputs.ServiceEndpointArgs =
        com.pulumi.azurenative.servicefabric.inputs.ServiceEndpointArgs.builder()
            .locations(locations?.applyValue({ args0 -> args0.map({ args0 -> args0 }) }))
            .service(service.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [ServiceEndpointArgs].
 */
@PulumiTagMarker
public class ServiceEndpointArgsBuilder internal constructor() {
    private var locations: Output<List<String>>? = null

    private var service: Output<String>? = null

    /**
     * @param value A list of locations.
     */
    @JvmName("uvddatjgdvrtfork")
    public suspend fun locations(`value`: Output<List<String>>) {
        this.locations = value
    }

    @JvmName("tvuboenbtejdmdcu")
    public suspend fun locations(vararg values: Output<String>) {
        this.locations = Output.all(values.asList())
    }

    /**
     * @param values A list of locations.
     */
    @JvmName("kluftuvdvanxfjhd")
    public suspend fun locations(values: List<Output<String>>) {
        this.locations = Output.all(values)
    }

    /**
     * @param value The type of the endpoint service.
     */
    @JvmName("clxvokrxyolweclm")
    public suspend fun service(`value`: Output<String>) {
        this.service = value
    }

    /**
     * @param value A list of locations.
     */
    @JvmName("fduopjdcbnxahfgk")
    public suspend fun locations(`value`: List<String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.locations = mapped
    }

    /**
     * @param values A list of locations.
     */
    @JvmName("kfypgxnxpyxaulbr")
    public suspend fun locations(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.locations = mapped
    }

    /**
     * @param value The type of the endpoint service.
     */
    @JvmName("snapwqimqflgwcnr")
    public suspend fun service(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.service = mapped
    }

    internal fun build(): ServiceEndpointArgs = ServiceEndpointArgs(
        locations = locations,
        service = service ?: throw PulumiNullFieldException("service"),
    )
}
