@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.servicefabric.kotlin.inputs

import com.pulumi.azurenative.servicefabric.inputs.ServicePlacementPreferPrimaryDomainPolicyArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * Describes the policy to be used for placement of a Service Fabric service where the service's
 * Primary replicas should optimally be placed in a particular domain.
 * This placement policy is usually used with fault domains in scenarios where the Service Fabric
 * cluster is geographically distributed in order to indicate that a service's primary replica should
 * be located in a particular fault domain, which in geo-distributed scenarios usually aligns with regional
 * or datacenter boundaries. Note that since this is an optimization it is possible that the Primary replica
 * may not end up located in this domain due to failures, capacity limits, or other constraints.
 * @property domainName The name of the domain that should used for placement as per this policy.
 * @property type The type of placement policy for a service fabric service. Following are the possible values.
 * Expected value is 'PreferredPrimaryDomain'.
 */
public data class ServicePlacementPreferPrimaryDomainPolicyArgs(
    public val domainName: Output<String>,
    public val type: Output<String>,
) :
    ConvertibleToJava<com.pulumi.azurenative.servicefabric.inputs.ServicePlacementPreferPrimaryDomainPolicyArgs> {
    override fun toJava(): com.pulumi.azurenative.servicefabric.inputs.ServicePlacementPreferPrimaryDomainPolicyArgs =
        com.pulumi.azurenative.servicefabric.inputs.ServicePlacementPreferPrimaryDomainPolicyArgs.builder()
            .domainName(domainName.applyValue({ args0 -> args0 }))
            .type(type.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [ServicePlacementPreferPrimaryDomainPolicyArgs].
 */
@PulumiTagMarker
public class ServicePlacementPreferPrimaryDomainPolicyArgsBuilder internal constructor() {
    private var domainName: Output<String>? = null

    private var type: Output<String>? = null

    /**
     * @param value The name of the domain that should used for placement as per this policy.
     */
    @JvmName("ifttjipksojdpasy")
    public suspend fun domainName(`value`: Output<String>) {
        this.domainName = value
    }

    /**
     * @param value The type of placement policy for a service fabric service. Following are the possible values.
     * Expected value is 'PreferredPrimaryDomain'.
     */
    @JvmName("gpauudkndtsujneo")
    public suspend fun type(`value`: Output<String>) {
        this.type = value
    }

    /**
     * @param value The name of the domain that should used for placement as per this policy.
     */
    @JvmName("jnvyyndbnvsrwgex")
    public suspend fun domainName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.domainName = mapped
    }

    /**
     * @param value The type of placement policy for a service fabric service. Following are the possible values.
     * Expected value is 'PreferredPrimaryDomain'.
     */
    @JvmName("amkkykjgjwfrcmoy")
    public suspend fun type(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.type = mapped
    }

    internal fun build(): ServicePlacementPreferPrimaryDomainPolicyArgs =
        ServicePlacementPreferPrimaryDomainPolicyArgs(
            domainName = domainName ?: throw PulumiNullFieldException("domainName"),
            type = type ?: throw PulumiNullFieldException("type"),
        )
}
