@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.servicefabric.kotlin.inputs

import com.pulumi.azurenative.servicefabric.inputs.ServicePlacementRequireDomainDistributionPolicyArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * Describes the policy to be used for placement of a Service Fabric service where two replicas
 * from the same partition should never be placed in the same fault or upgrade domain.
 * While this is not common it can expose the service to an increased risk of concurrent failures
 * due to unplanned outages or other cases of subsequent/concurrent failures. As an example, consider
 * a case where replicas are deployed across different data center, with one replica per location.
 * In the event that one of the datacenters goes offline, normally the replica that was placed in that
 * datacenter will be packed into one of the remaining datacenters. If this is not desirable then this
 * policy should be set.
 * @property domainName The name of the domain that should used for placement as per this policy.
 * @property type The type of placement policy for a service fabric service. Following are the possible values.
 * Expected value is 'RequiredDomainDistribution'.
 */
public data class ServicePlacementRequireDomainDistributionPolicyArgs(
    public val domainName: Output<String>,
    public val type: Output<String>,
) :
    ConvertibleToJava<com.pulumi.azurenative.servicefabric.inputs.ServicePlacementRequireDomainDistributionPolicyArgs> {
    override fun toJava(): com.pulumi.azurenative.servicefabric.inputs.ServicePlacementRequireDomainDistributionPolicyArgs =
        com.pulumi.azurenative.servicefabric.inputs.ServicePlacementRequireDomainDistributionPolicyArgs.builder()
            .domainName(domainName.applyValue({ args0 -> args0 }))
            .type(type.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [ServicePlacementRequireDomainDistributionPolicyArgs].
 */
@PulumiTagMarker
public class ServicePlacementRequireDomainDistributionPolicyArgsBuilder internal constructor() {
    private var domainName: Output<String>? = null

    private var type: Output<String>? = null

    /**
     * @param value The name of the domain that should used for placement as per this policy.
     */
    @JvmName("mdpnhmokxnkrrnyd")
    public suspend fun domainName(`value`: Output<String>) {
        this.domainName = value
    }

    /**
     * @param value The type of placement policy for a service fabric service. Following are the possible values.
     * Expected value is 'RequiredDomainDistribution'.
     */
    @JvmName("jrbcakifdcvypplb")
    public suspend fun type(`value`: Output<String>) {
        this.type = value
    }

    /**
     * @param value The name of the domain that should used for placement as per this policy.
     */
    @JvmName("tycfumdjiebepris")
    public suspend fun domainName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.domainName = mapped
    }

    /**
     * @param value The type of placement policy for a service fabric service. Following are the possible values.
     * Expected value is 'RequiredDomainDistribution'.
     */
    @JvmName("jcasaueidjwvmpqr")
    public suspend fun type(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.type = mapped
    }

    internal fun build(): ServicePlacementRequireDomainDistributionPolicyArgs =
        ServicePlacementRequireDomainDistributionPolicyArgs(
            domainName = domainName ?: throw PulumiNullFieldException("domainName"),
            type = type ?: throw PulumiNullFieldException("type"),
        )
}
