@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.servicefabric.kotlin.inputs

import com.pulumi.azurenative.servicefabric.inputs.VmManagedIdentityArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 * Identities for the virtual machine scale set under the node type.
 * @property userAssignedIdentities The list of user identities associated with the virtual machine scale set under the node type. Each entry will be an ARM resource ids in the form: '/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.ManagedIdentity/userAssignedIdentities/{identityName}'.
 */
public data class VmManagedIdentityArgs(
    public val userAssignedIdentities: Output<List<String>>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.servicefabric.inputs.VmManagedIdentityArgs> {
    override fun toJava(): com.pulumi.azurenative.servicefabric.inputs.VmManagedIdentityArgs =
        com.pulumi.azurenative.servicefabric.inputs.VmManagedIdentityArgs.builder()
            .userAssignedIdentities(
                userAssignedIdentities?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0
                    })
                }),
            ).build()
}

/**
 * Builder for [VmManagedIdentityArgs].
 */
@PulumiTagMarker
public class VmManagedIdentityArgsBuilder internal constructor() {
    private var userAssignedIdentities: Output<List<String>>? = null

    /**
     * @param value The list of user identities associated with the virtual machine scale set under the node type. Each entry will be an ARM resource ids in the form: '/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.ManagedIdentity/userAssignedIdentities/{identityName}'.
     */
    @JvmName("rrgsbvqxxtagwwnj")
    public suspend fun userAssignedIdentities(`value`: Output<List<String>>) {
        this.userAssignedIdentities = value
    }

    @JvmName("lxkmeqbtgwmijgia")
    public suspend fun userAssignedIdentities(vararg values: Output<String>) {
        this.userAssignedIdentities = Output.all(values.asList())
    }

    /**
     * @param values The list of user identities associated with the virtual machine scale set under the node type. Each entry will be an ARM resource ids in the form: '/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.ManagedIdentity/userAssignedIdentities/{identityName}'.
     */
    @JvmName("vsghabqeywnvhpjl")
    public suspend fun userAssignedIdentities(values: List<Output<String>>) {
        this.userAssignedIdentities = Output.all(values)
    }

    /**
     * @param value The list of user identities associated with the virtual machine scale set under the node type. Each entry will be an ARM resource ids in the form: '/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.ManagedIdentity/userAssignedIdentities/{identityName}'.
     */
    @JvmName("aktayixvveovmejj")
    public suspend fun userAssignedIdentities(`value`: List<String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.userAssignedIdentities = mapped
    }

    /**
     * @param values The list of user identities associated with the virtual machine scale set under the node type. Each entry will be an ARM resource ids in the form: '/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.ManagedIdentity/userAssignedIdentities/{identityName}'.
     */
    @JvmName("neftrkmmurjxapag")
    public suspend fun userAssignedIdentities(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.userAssignedIdentities = mapped
    }

    internal fun build(): VmManagedIdentityArgs = VmManagedIdentityArgs(
        userAssignedIdentities = userAssignedIdentities,
    )
}
