@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.servicefabric.kotlin.inputs

import com.pulumi.azurenative.servicefabric.inputs.VmssDataDiskArgs.builder
import com.pulumi.azurenative.servicefabric.kotlin.enums.DiskType
import com.pulumi.core.Either
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * Managed data disk description.
 * @property diskLetter Managed data disk letter. It can not use the reserved letter C or D and it can not change after created.
 * @property diskSizeGB Disk size for each vm in the node type in GBs.
 * @property diskType Managed data disk type. Specifies the storage account type for the managed disk
 * @property lun Specifies the logical unit number of the data disk. This value is used to identify data disks within the VM and therefore must be unique for each data disk attached to a VM. Lun 0 is reserved for the service fabric data disk.
 */
public data class VmssDataDiskArgs(
    public val diskLetter: Output<String>,
    public val diskSizeGB: Output<Int>,
    public val diskType: Output<Either<String, DiskType>>,
    public val lun: Output<Int>,
) : ConvertibleToJava<com.pulumi.azurenative.servicefabric.inputs.VmssDataDiskArgs> {
    override fun toJava(): com.pulumi.azurenative.servicefabric.inputs.VmssDataDiskArgs =
        com.pulumi.azurenative.servicefabric.inputs.VmssDataDiskArgs.builder()
            .diskLetter(diskLetter.applyValue({ args0 -> args0 }))
            .diskSizeGB(diskSizeGB.applyValue({ args0 -> args0 }))
            .diskType(
                diskType.applyValue({ args0 ->
                    args0.transform({ args0 -> args0 }, { args0 ->
                        args0.let({ args0 -> args0.toJava() })
                    })
                }),
            )
            .lun(lun.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [VmssDataDiskArgs].
 */
@PulumiTagMarker
public class VmssDataDiskArgsBuilder internal constructor() {
    private var diskLetter: Output<String>? = null

    private var diskSizeGB: Output<Int>? = null

    private var diskType: Output<Either<String, DiskType>>? = null

    private var lun: Output<Int>? = null

    /**
     * @param value Managed data disk letter. It can not use the reserved letter C or D and it can not change after created.
     */
    @JvmName("oeqfbnfipskndcyb")
    public suspend fun diskLetter(`value`: Output<String>) {
        this.diskLetter = value
    }

    /**
     * @param value Disk size for each vm in the node type in GBs.
     */
    @JvmName("ooyllsfsybdoucsi")
    public suspend fun diskSizeGB(`value`: Output<Int>) {
        this.diskSizeGB = value
    }

    /**
     * @param value Managed data disk type. Specifies the storage account type for the managed disk
     */
    @JvmName("wdysttxmjcplfago")
    public suspend fun diskType(`value`: Output<Either<String, DiskType>>) {
        this.diskType = value
    }

    /**
     * @param value Specifies the logical unit number of the data disk. This value is used to identify data disks within the VM and therefore must be unique for each data disk attached to a VM. Lun 0 is reserved for the service fabric data disk.
     */
    @JvmName("wxyhkaswfugeeyms")
    public suspend fun lun(`value`: Output<Int>) {
        this.lun = value
    }

    /**
     * @param value Managed data disk letter. It can not use the reserved letter C or D and it can not change after created.
     */
    @JvmName("wulxhgpiuhmeygnc")
    public suspend fun diskLetter(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.diskLetter = mapped
    }

    /**
     * @param value Disk size for each vm in the node type in GBs.
     */
    @JvmName("dqasvelpfrddcebi")
    public suspend fun diskSizeGB(`value`: Int) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.diskSizeGB = mapped
    }

    /**
     * @param value Managed data disk type. Specifies the storage account type for the managed disk
     */
    @JvmName("sufxlmrndbfaqfuu")
    public suspend fun diskType(`value`: Either<String, DiskType>) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.diskType = mapped
    }

    /**
     * @param value Managed data disk type. Specifies the storage account type for the managed disk
     */
    @JvmName("jhndpqpsckulcbwi")
    public fun diskType(`value`: String) {
        val toBeMapped = Either.ofLeft<String, DiskType>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.diskType = mapped
    }

    /**
     * @param value Managed data disk type. Specifies the storage account type for the managed disk
     */
    @JvmName("kmhlvuvibnnsfgvb")
    public fun diskType(`value`: DiskType) {
        val toBeMapped = Either.ofRight<String, DiskType>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.diskType = mapped
    }

    /**
     * @param value Specifies the logical unit number of the data disk. This value is used to identify data disks within the VM and therefore must be unique for each data disk attached to a VM. Lun 0 is reserved for the service fabric data disk.
     */
    @JvmName("lcjjwfdvocwpncxt")
    public suspend fun lun(`value`: Int) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.lun = mapped
    }

    internal fun build(): VmssDataDiskArgs = VmssDataDiskArgs(
        diskLetter = diskLetter ?: throw PulumiNullFieldException("diskLetter"),
        diskSizeGB = diskSizeGB ?: throw PulumiNullFieldException("diskSizeGB"),
        diskType = diskType ?: throw PulumiNullFieldException("diskType"),
        lun = lun ?: throw PulumiNullFieldException("lun"),
    )
}
