@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.servicefabric.kotlin.outputs

import kotlin.Int
import kotlin.String
import kotlin.Suppress

/**
 * Represents a scaling mechanism for adding or removing named partitions of a stateless service. Partition names are in the format '0','1'...'N-1'.
 * @property kind Enumerates the ways that a service can be partitioned.
 * Expected value is 'AddRemoveIncrementalNamedPartition'.
 * @property maxPartitionCount Maximum number of named partitions of the service.
 * @property minPartitionCount Minimum number of named partitions of the service.
 * @property scaleIncrement The number of instances to add or remove during a scaling operation.
 */
public data class AddRemoveIncrementalNamedPartitionScalingMechanismResponse(
    public val kind: String,
    public val maxPartitionCount: Int,
    public val minPartitionCount: Int,
    public val scaleIncrement: Int,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.servicefabric.outputs.AddRemoveIncrementalNamedPartitionScalingMechanismResponse): AddRemoveIncrementalNamedPartitionScalingMechanismResponse =
            AddRemoveIncrementalNamedPartitionScalingMechanismResponse(
                kind = javaType.kind(),
                maxPartitionCount = javaType.maxPartitionCount(),
                minPartitionCount = javaType.minPartitionCount(),
                scaleIncrement = javaType.scaleIncrement(),
            )
    }
}
