@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.servicefabric.kotlin.outputs

import kotlin.Boolean
import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.collections.Map

/**
 * Defines a health policy used to evaluate the health of an application or one of its children entities.
 * @property considerWarningAsError Indicates whether warnings are treated with the same severity as errors.
 * @property defaultServiceTypeHealthPolicy The health policy used by default to evaluate the health of a service type.
 * @property maxPercentUnhealthyDeployedApplications The maximum allowed percentage of unhealthy deployed applications. Allowed values are Byte values from zero to 100.
 * The percentage represents the maximum tolerated percentage of deployed applications that can be unhealthy before the application is considered in error.
 * This is calculated by dividing the number of unhealthy deployed applications over the number of nodes where the application is currently deployed on in the cluster.
 * The computation rounds up to tolerate one failure on small numbers of nodes. Default percentage is zero.
 * @property serviceTypeHealthPolicyMap The map with service type health policy per service type name. The map is empty by default.
 */
public data class ApplicationHealthPolicyResponse(
    public val considerWarningAsError: Boolean,
    public val defaultServiceTypeHealthPolicy: ServiceTypeHealthPolicyResponse? = null,
    public val maxPercentUnhealthyDeployedApplications: Int,
    public val serviceTypeHealthPolicyMap: Map<String, ServiceTypeHealthPolicyResponse>? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.servicefabric.outputs.ApplicationHealthPolicyResponse): ApplicationHealthPolicyResponse = ApplicationHealthPolicyResponse(
            considerWarningAsError = javaType.considerWarningAsError(),
            defaultServiceTypeHealthPolicy = javaType.defaultServiceTypeHealthPolicy().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.servicefabric.kotlin.outputs.ServiceTypeHealthPolicyResponse.Companion.toKotlin(args0)
                })
            }).orElse(null),
            maxPercentUnhealthyDeployedApplications = javaType.maxPercentUnhealthyDeployedApplications(),
            serviceTypeHealthPolicyMap = javaType.serviceTypeHealthPolicyMap().map({ args0 ->
                args0.key.to(
                    args0.value.let({ args0 ->
                        com.pulumi.azurenative.servicefabric.kotlin.outputs.ServiceTypeHealthPolicyResponse.Companion.toKotlin(args0)
                    }),
                )
            }).toMap(),
        )
    }
}
