@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.servicefabric.kotlin.outputs

import kotlin.Boolean
import kotlin.Double
import kotlin.String
import kotlin.Suppress

/**
 * Describes the policy for a monitored application upgrade.
 * @property applicationHealthPolicy Defines a health policy used to evaluate the health of an application or one of its children entities.
 * @property forceRestart If true, then processes are forcefully restarted during upgrade even when the code version has not changed (the upgrade only changes configuration or data).
 * @property instanceCloseDelayDuration Duration in seconds, to wait before a stateless instance is closed, to allow the active requests to drain gracefully. This would be effective when the instance is closing during the application/cluster upgrade, only for those instances which have a non-zero delay duration configured in the service description.
 * @property recreateApplication Determines whether the application should be recreated on update. If value=true, the rest of the upgrade policy parameters are not allowed.
 * @property rollingUpgradeMonitoringPolicy The policy used for monitoring the application upgrade
 * @property upgradeMode The mode used to monitor health during a rolling upgrade. The values are Monitored, and UnmonitoredAuto.
 * @property upgradeReplicaSetCheckTimeout The maximum amount of time to block processing of an upgrade domain and prevent loss of availability when there are unexpected issues. When this timeout expires, processing of the upgrade domain will proceed regardless of availability loss issues. The timeout is reset at the start of each upgrade domain. Valid values are between 0 and 42949672925 inclusive. (unsigned 32-bit integer).
 */
public data class ApplicationUpgradePolicyResponse(
    public val applicationHealthPolicy: ApplicationHealthPolicyResponse? = null,
    public val forceRestart: Boolean? = null,
    public val instanceCloseDelayDuration: Double? = null,
    public val recreateApplication: Boolean? = null,
    public val rollingUpgradeMonitoringPolicy: RollingUpgradeMonitoringPolicyResponse? = null,
    public val upgradeMode: String? = null,
    public val upgradeReplicaSetCheckTimeout: Double? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.servicefabric.outputs.ApplicationUpgradePolicyResponse): ApplicationUpgradePolicyResponse = ApplicationUpgradePolicyResponse(
            applicationHealthPolicy = javaType.applicationHealthPolicy().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.servicefabric.kotlin.outputs.ApplicationHealthPolicyResponse.Companion.toKotlin(args0)
                })
            }).orElse(null),
            forceRestart = javaType.forceRestart().map({ args0 -> args0 }).orElse(null),
            instanceCloseDelayDuration = javaType.instanceCloseDelayDuration().map({ args0 ->
                args0
            }).orElse(null),
            recreateApplication = javaType.recreateApplication().map({ args0 -> args0 }).orElse(null),
            rollingUpgradeMonitoringPolicy = javaType.rollingUpgradeMonitoringPolicy().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.servicefabric.kotlin.outputs.RollingUpgradeMonitoringPolicyResponse.Companion.toKotlin(args0)
                })
            }).orElse(null),
            upgradeMode = javaType.upgradeMode().map({ args0 -> args0 }).orElse(null),
            upgradeReplicaSetCheckTimeout = javaType.upgradeReplicaSetCheckTimeout().map({ args0 ->
                args0
            }).orElse(null),
        )
    }
}
