@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.servicefabric.kotlin.outputs

import kotlin.Double
import kotlin.String
import kotlin.Suppress

/**
 * Represents a scaling trigger related to an average load of a metric/resource of a partition.
 * @property kind Enumerates the ways that a service can be partitioned.
 * Expected value is 'AveragePartitionLoadTrigger'.
 * @property lowerLoadThreshold The lower limit of the load below which a scale in operation should be performed.
 * @property metricName The name of the metric for which usage should be tracked.
 * @property scaleInterval The period in seconds on which a decision is made whether to scale or not. This property should come in ISO 8601 format "hh:mm:ss".
 * @property upperLoadThreshold The upper limit of the load beyond which a scale out operation should be performed.
 */
public data class AveragePartitionLoadScalingTriggerResponse(
    public val kind: String,
    public val lowerLoadThreshold: Double,
    public val metricName: String,
    public val scaleInterval: String,
    public val upperLoadThreshold: Double,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.servicefabric.outputs.AveragePartitionLoadScalingTriggerResponse): AveragePartitionLoadScalingTriggerResponse = AveragePartitionLoadScalingTriggerResponse(
            kind = javaType.kind(),
            lowerLoadThreshold = javaType.lowerLoadThreshold(),
            metricName = javaType.metricName(),
            scaleInterval = javaType.scaleInterval(),
            upperLoadThreshold = javaType.upperLoadThreshold(),
        )
    }
}
