@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.servicefabric.kotlin.outputs

import kotlin.Boolean
import kotlin.Double
import kotlin.String
import kotlin.Suppress

/**
 * Represents a scaling policy related to an average load of a metric/resource of a service.
 * @property kind Enumerates the ways that a service can be partitioned.
 * Expected value is 'AverageServiceLoadTrigger'.
 * @property lowerLoadThreshold The lower limit of the load below which a scale in operation should be performed.
 * @property metricName The name of the metric for which usage should be tracked.
 * @property scaleInterval The period in seconds on which a decision is made whether to scale or not. This property should come in ISO 8601 format "hh:mm:ss".
 * @property upperLoadThreshold The upper limit of the load beyond which a scale out operation should be performed.
 * @property useOnlyPrimaryLoad Flag determines whether only the load of primary replica should be considered for scaling. If set to true, then trigger will only consider the load of primary replicas of stateful service. If set to false, trigger will consider load of all replicas. This parameter cannot be set to true for stateless service.
 */
public data class AverageServiceLoadScalingTriggerResponse(
    public val kind: String,
    public val lowerLoadThreshold: Double,
    public val metricName: String,
    public val scaleInterval: String,
    public val upperLoadThreshold: Double,
    public val useOnlyPrimaryLoad: Boolean,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.servicefabric.outputs.AverageServiceLoadScalingTriggerResponse): AverageServiceLoadScalingTriggerResponse = AverageServiceLoadScalingTriggerResponse(
            kind = javaType.kind(),
            lowerLoadThreshold = javaType.lowerLoadThreshold(),
            metricName = javaType.metricName(),
            scaleInterval = javaType.scaleInterval(),
            upperLoadThreshold = javaType.upperLoadThreshold(),
            useOnlyPrimaryLoad = javaType.useOnlyPrimaryLoad(),
        )
    }
}
