@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.servicefabric.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 * The settings to enable AAD authentication on the cluster.
 * @property clientApplication Azure active directory client application id.
 * @property clusterApplication Azure active directory cluster application id.
 * @property tenantId Azure active directory tenant id.
 */
public data class AzureActiveDirectoryResponse(
    public val clientApplication: String? = null,
    public val clusterApplication: String? = null,
    public val tenantId: String? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.servicefabric.outputs.AzureActiveDirectoryResponse): AzureActiveDirectoryResponse = AzureActiveDirectoryResponse(
            clientApplication = javaType.clientApplication().map({ args0 -> args0 }).orElse(null),
            clusterApplication = javaType.clusterApplication().map({ args0 -> args0 }).orElse(null),
            tenantId = javaType.tenantId().map({ args0 -> args0 }).orElse(null),
        )
    }
}
