@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.servicefabric.kotlin.outputs

import kotlin.Boolean
import kotlin.String
import kotlin.Suppress

/**
 * Client certificate definition.
 * @property commonName Certificate common name.
 * @property isAdmin Indicates if the client certificate has admin access to the cluster. Non admin clients can perform only read only operations on the cluster.
 * @property issuerThumbprint Issuer thumbprint for the certificate. Only used together with CommonName.
 * @property thumbprint Certificate thumbprint.
 */
public data class ClientCertificateResponse(
    public val commonName: String? = null,
    public val isAdmin: Boolean,
    public val issuerThumbprint: String? = null,
    public val thumbprint: String? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.servicefabric.outputs.ClientCertificateResponse): ClientCertificateResponse = ClientCertificateResponse(
            commonName = javaType.commonName().map({ args0 -> args0 }).orElse(null),
            isAdmin = javaType.isAdmin(),
            issuerThumbprint = javaType.issuerThumbprint().map({ args0 -> args0 }).orElse(null),
            thumbprint = javaType.thumbprint().map({ args0 -> args0 }).orElse(null),
        )
    }
}
