@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.servicefabric.kotlin.outputs

import kotlin.Int
import kotlin.Suppress

/**
 * Port range details
 * @property endPort End port of a range of ports
 * @property startPort Starting port of a range of ports
 */
public data class EndpointRangeDescriptionResponse(
    public val endPort: Int,
    public val startPort: Int,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.servicefabric.outputs.EndpointRangeDescriptionResponse): EndpointRangeDescriptionResponse = EndpointRangeDescriptionResponse(
            endPort = javaType.endPort(),
            startPort = javaType.startPort(),
        )
    }
}
