@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.servicefabric.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 * Describes the frontend configurations for the node type.
 * @property applicationGatewayBackendAddressPoolId The resource Id of application gateway backend address pool. The format of the resource Id is '/subscriptions/<subscriptionId>/resourceGroups/<resourceGroupName>/providers/Microsoft.Network/applicationGateways/<applicationGatewayName>/backendAddressPools/<backendAddressPoolName>'.
 * @property ipAddressType The IP address type of this frontend configuration. If omitted the default value is IPv4.
 * @property loadBalancerBackendAddressPoolId The resource Id of the Load Balancer backend address pool that the VM instances of the node type are associated with. The format of the resource Id is '/subscriptions/<subscriptionId>/resourceGroups/<resourceGroupName>/providers/Microsoft.Network/loadBalancers/<loadBalancerName>/backendAddressPools/<backendAddressPoolName>'.
 * @property loadBalancerInboundNatPoolId The resource Id of the Load Balancer inbound NAT pool that the VM instances of the node type are associated with. The format of the resource Id is '/subscriptions/<subscriptionId>/resourceGroups/<resourceGroupName>/providers/Microsoft.Network/loadBalancers/<loadBalancerName>/inboundNatPools/<inboundNatPoolName>'.
 */
public data class FrontendConfigurationResponse(
    public val applicationGatewayBackendAddressPoolId: String? = null,
    public val ipAddressType: String? = null,
    public val loadBalancerBackendAddressPoolId: String? = null,
    public val loadBalancerInboundNatPoolId: String? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.servicefabric.outputs.FrontendConfigurationResponse): FrontendConfigurationResponse = FrontendConfigurationResponse(
            applicationGatewayBackendAddressPoolId = javaType.applicationGatewayBackendAddressPoolId().map({ args0 ->
                args0
            }).orElse(null),
            ipAddressType = javaType.ipAddressType().map({ args0 -> args0 }).orElse(null),
            loadBalancerBackendAddressPoolId = javaType.loadBalancerBackendAddressPoolId().map({ args0 ->
                args0
            }).orElse(null),
            loadBalancerInboundNatPoolId = javaType.loadBalancerInboundNatPoolId().map({ args0 ->
                args0
            }).orElse(null),
        )
    }
}
