@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.servicefabric.kotlin.outputs

import kotlin.String
import kotlin.Suppress
import kotlin.collections.Map

/**
 * The application type name resource
 * @property id Azure resource identifier.
 * @property location Resource location depends on the parent resource.
 * @property name Azure resource name.
 * @property provisioningState The current deployment or provisioning state, which only appears in the response.
 * @property systemData Metadata pertaining to creation and last modification of the resource.
 * @property tags Azure resource tags.
 * @property type Azure resource type.
 */
public data class GetManagedClusterApplicationTypeResult(
    public val id: String,
    public val location: String? = null,
    public val name: String,
    public val provisioningState: String,
    public val systemData: SystemDataResponse,
    public val tags: Map<String, String>? = null,
    public val type: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.servicefabric.outputs.GetManagedClusterApplicationTypeResult): GetManagedClusterApplicationTypeResult = GetManagedClusterApplicationTypeResult(
            id = javaType.id(),
            location = javaType.location().map({ args0 -> args0 }).orElse(null),
            name = javaType.name(),
            provisioningState = javaType.provisioningState(),
            systemData = javaType.systemData().let({ args0 ->
                com.pulumi.azurenative.servicefabric.kotlin.outputs.SystemDataResponse.Companion.toKotlin(args0)
            }),
            tags = javaType.tags().map({ args0 -> args0.key.to(args0.value) }).toMap(),
            type = javaType.type(),
        )
    }
}
