@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.servicefabric.kotlin.outputs

import kotlin.Boolean
import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List
import kotlin.collections.Map

/**
 * Describes a node type in the cluster, each node type represents sub set of nodes in the cluster.
 * @property additionalDataDisks Additional managed data disks.
 * @property applicationPorts The range of ports from which cluster assigned port to Service Fabric applications.
 * @property capacities The capacity tags applied to the nodes in the node type, the cluster resource manager uses these tags to understand how much resource a node has.
 * @property dataDiskLetter Managed data disk letter. It can not use the reserved letter C or D and it can not change after created.
 * @property dataDiskSizeGB Disk size for the managed disk attached to the vms on the node type in GBs.
 * @property dataDiskType Managed data disk type. Specifies the storage account type for the managed disk
 * @property enableAcceleratedNetworking Specifies whether the network interface is accelerated networking-enabled.
 * @property enableEncryptionAtHost Enable or disable the Host Encryption for the virtual machines on the node type. This will enable the encryption for all the disks including Resource/Temp disk at host itself. Default: The Encryption at host will be disabled unless this property is set to true for the resource.
 * @property enableNodePublicIP Specifies whether each node is allocated its own public IP address. This is only supported on secondary node types with custom Load Balancers.
 * @property enableOverProvisioning Specifies whether the node type should be overprovisioned. It is only allowed for stateless node types.
 * @property ephemeralPorts The range of ephemeral ports that nodes in this node type should be configured with.
 * @property evictionPolicy Specifies the eviction policy for virtual machines in a SPOT node type. Default is Delete.
 * @property frontendConfigurations Indicates the node type uses its own frontend configurations instead of the default one for the cluster. This setting can only be specified for non-primary node types and can not be added or removed after the node type is created.
 * @property hostGroupId Specifies the full host group resource Id. This property is used for deploying on azure dedicated hosts.
 * @property id Azure resource identifier.
 * @property isPrimary Indicates the Service Fabric system services for the cluster will run on this node type. This setting cannot be changed once the node type is created.
 * @property isSpotVM Indicates whether the node type will be Spot Virtual Machines. Azure will allocate the VMs if there is capacity available and the VMs can be evicted at any time.
 * @property isStateless Indicates if the node type can only host Stateless workloads.
 * @property multiplePlacementGroups Indicates if scale set associated with the node type can be composed of multiple placement groups.
 * @property name Azure resource name.
 * @property natGatewayId Specifies the resource id of a NAT Gateway to attach to the subnet of this node type. Node type must use custom load balancer.
 * @property networkSecurityRules The Network Security Rules for this node type. This setting can only be specified for node types that are configured with frontend configurations.
 * @property placementProperties The placement tags applied to nodes in the node type, which can be used to indicate where certain services (workload) should run.
 * @property provisioningState The provisioning state of the node type resource.
 * @property secureBootEnabled Specifies whether secure boot should be enabled on the nodeType. Can only be used with TrustedLaunch SecurityType
 * @property securityType Specifies the security type of the nodeType. Only TrustedLaunch is currently supported
 * @property sku The node type sku.
 * @property spotRestoreTimeout Indicates the time duration after which the platform will not try to restore the VMSS SPOT instances specified as ISO 8601.
 * @property subnetId Indicates the resource id of the subnet for the node type.
 * @property systemData Metadata pertaining to creation and last modification of the resource.
 * @property tags Azure resource tags.
 * @property type Azure resource type.
 * @property useDefaultPublicLoadBalancer Specifies whether the use public load balancer. If not specified and the node type doesn't have its own frontend configuration, it will be attached to the default load balancer. If the node type uses its own Load balancer and useDefaultPublicLoadBalancer is true, then the frontend has to be an Internal Load Balancer. If the node type uses its own Load balancer and useDefaultPublicLoadBalancer is false or not set, then the custom load balancer must include a public load balancer to provide outbound connectivity.
 * @property useEphemeralOSDisk Indicates whether to use ephemeral os disk. The sku selected on the vmSize property needs to support this feature.
 * @property useTempDataDisk Specifies whether to use the temporary disk for the service fabric data root, in which case no managed data disk will be attached and the temporary disk will be used. It is only allowed for stateless node types.
 * @property vmExtensions Set of extensions that should be installed onto the virtual machines.
 * @property vmImageOffer The offer type of the Azure Virtual Machines Marketplace image. For example, UbuntuServer or WindowsServer.
 * @property vmImagePlan Specifies information about the marketplace image used to create the virtual machine. This element is only used for marketplace images. Before you can use a marketplace image from an API, you must enable the image for programmatic use. In the Azure portal, find the marketplace image that you want to use and then click Want to deploy programmatically, Get Started ->. Enter any required information and then click Save.
 * @property vmImagePublisher The publisher of the Azure Virtual Machines Marketplace image. For example, Canonical or MicrosoftWindowsServer.
 * @property vmImageResourceId Indicates the resource id of the vm image. This parameter is used for custom vm image.
 * @property vmImageSku The SKU of the Azure Virtual Machines Marketplace image. For example, 14.04.0-LTS or 2012-R2-Datacenter.
 * @property vmImageVersion The version of the Azure Virtual Machines Marketplace image. A value of 'latest' can be specified to select the latest version of an image. If omitted, the default is 'latest'.
 * @property vmInstanceCount The number of nodes in the node type. <br /><br />**Values:** <br />-1 - Use when auto scale rules are configured or sku.capacity is defined <br /> 0 - Not supported <br /> >0 - Use for manual scale.
 * @property vmManagedIdentity Identities to assign to the virtual machine scale set under the node type.
 * @property vmSecrets The secrets to install in the virtual machines.
 * @property vmSetupActions Specifies the actions to be performed on the vms before bootstrapping the service fabric runtime.
 * @property vmSharedGalleryImageId Indicates the resource id of the vm shared galleries image. This parameter is used for custom vm image.
 * @property vmSize The size of virtual machines in the pool. All virtual machines in a pool are the same size. For example, Standard_D3.
 * @property zones Specifies the availability zones where the node type would span across. If the cluster is not spanning across availability zones, initiates az migration for the cluster.
 */
public data class GetNodeTypeResult(
    public val additionalDataDisks: List<VmssDataDiskResponse>? = null,
    public val applicationPorts: EndpointRangeDescriptionResponse? = null,
    public val capacities: Map<String, String>? = null,
    public val dataDiskLetter: String? = null,
    public val dataDiskSizeGB: Int? = null,
    public val dataDiskType: String? = null,
    public val enableAcceleratedNetworking: Boolean? = null,
    public val enableEncryptionAtHost: Boolean? = null,
    public val enableNodePublicIP: Boolean? = null,
    public val enableOverProvisioning: Boolean? = null,
    public val ephemeralPorts: EndpointRangeDescriptionResponse? = null,
    public val evictionPolicy: String? = null,
    public val frontendConfigurations: List<FrontendConfigurationResponse>? = null,
    public val hostGroupId: String? = null,
    public val id: String,
    public val isPrimary: Boolean,
    public val isSpotVM: Boolean? = null,
    public val isStateless: Boolean? = null,
    public val multiplePlacementGroups: Boolean? = null,
    public val name: String,
    public val natGatewayId: String? = null,
    public val networkSecurityRules: List<NetworkSecurityRuleResponse>? = null,
    public val placementProperties: Map<String, String>? = null,
    public val provisioningState: String,
    public val secureBootEnabled: Boolean? = null,
    public val securityType: String? = null,
    public val sku: NodeTypeSkuResponse? = null,
    public val spotRestoreTimeout: String? = null,
    public val subnetId: String? = null,
    public val systemData: SystemDataResponse,
    public val tags: Map<String, String>? = null,
    public val type: String,
    public val useDefaultPublicLoadBalancer: Boolean? = null,
    public val useEphemeralOSDisk: Boolean? = null,
    public val useTempDataDisk: Boolean? = null,
    public val vmExtensions: List<VMSSExtensionResponse>? = null,
    public val vmImageOffer: String? = null,
    public val vmImagePlan: VmImagePlanResponse? = null,
    public val vmImagePublisher: String? = null,
    public val vmImageResourceId: String? = null,
    public val vmImageSku: String? = null,
    public val vmImageVersion: String? = null,
    public val vmInstanceCount: Int,
    public val vmManagedIdentity: VmManagedIdentityResponse? = null,
    public val vmSecrets: List<VaultSecretGroupResponse>? = null,
    public val vmSetupActions: List<String>? = null,
    public val vmSharedGalleryImageId: String? = null,
    public val vmSize: String? = null,
    public val zones: List<String>? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.servicefabric.outputs.GetNodeTypeResult): GetNodeTypeResult = GetNodeTypeResult(
            additionalDataDisks = javaType.additionalDataDisks().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.servicefabric.kotlin.outputs.VmssDataDiskResponse.Companion.toKotlin(args0)
                })
            }),
            applicationPorts = javaType.applicationPorts().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.servicefabric.kotlin.outputs.EndpointRangeDescriptionResponse.Companion.toKotlin(args0)
                })
            }).orElse(null),
            capacities = javaType.capacities().map({ args0 -> args0.key.to(args0.value) }).toMap(),
            dataDiskLetter = javaType.dataDiskLetter().map({ args0 -> args0 }).orElse(null),
            dataDiskSizeGB = javaType.dataDiskSizeGB().map({ args0 -> args0 }).orElse(null),
            dataDiskType = javaType.dataDiskType().map({ args0 -> args0 }).orElse(null),
            enableAcceleratedNetworking = javaType.enableAcceleratedNetworking().map({ args0 ->
                args0
            }).orElse(null),
            enableEncryptionAtHost = javaType.enableEncryptionAtHost().map({ args0 -> args0 }).orElse(null),
            enableNodePublicIP = javaType.enableNodePublicIP().map({ args0 -> args0 }).orElse(null),
            enableOverProvisioning = javaType.enableOverProvisioning().map({ args0 -> args0 }).orElse(null),
            ephemeralPorts = javaType.ephemeralPorts().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.servicefabric.kotlin.outputs.EndpointRangeDescriptionResponse.Companion.toKotlin(args0)
                })
            }).orElse(null),
            evictionPolicy = javaType.evictionPolicy().map({ args0 -> args0 }).orElse(null),
            frontendConfigurations = javaType.frontendConfigurations().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.servicefabric.kotlin.outputs.FrontendConfigurationResponse.Companion.toKotlin(args0)
                })
            }),
            hostGroupId = javaType.hostGroupId().map({ args0 -> args0 }).orElse(null),
            id = javaType.id(),
            isPrimary = javaType.isPrimary(),
            isSpotVM = javaType.isSpotVM().map({ args0 -> args0 }).orElse(null),
            isStateless = javaType.isStateless().map({ args0 -> args0 }).orElse(null),
            multiplePlacementGroups = javaType.multiplePlacementGroups().map({ args0 -> args0 }).orElse(null),
            name = javaType.name(),
            natGatewayId = javaType.natGatewayId().map({ args0 -> args0 }).orElse(null),
            networkSecurityRules = javaType.networkSecurityRules().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.servicefabric.kotlin.outputs.NetworkSecurityRuleResponse.Companion.toKotlin(args0)
                })
            }),
            placementProperties = javaType.placementProperties().map({ args0 ->
                args0.key.to(args0.value)
            }).toMap(),
            provisioningState = javaType.provisioningState(),
            secureBootEnabled = javaType.secureBootEnabled().map({ args0 -> args0 }).orElse(null),
            securityType = javaType.securityType().map({ args0 -> args0 }).orElse(null),
            sku = javaType.sku().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.servicefabric.kotlin.outputs.NodeTypeSkuResponse.Companion.toKotlin(args0)
                })
            }).orElse(null),
            spotRestoreTimeout = javaType.spotRestoreTimeout().map({ args0 -> args0 }).orElse(null),
            subnetId = javaType.subnetId().map({ args0 -> args0 }).orElse(null),
            systemData = javaType.systemData().let({ args0 ->
                com.pulumi.azurenative.servicefabric.kotlin.outputs.SystemDataResponse.Companion.toKotlin(args0)
            }),
            tags = javaType.tags().map({ args0 -> args0.key.to(args0.value) }).toMap(),
            type = javaType.type(),
            useDefaultPublicLoadBalancer = javaType.useDefaultPublicLoadBalancer().map({ args0 ->
                args0
            }).orElse(null),
            useEphemeralOSDisk = javaType.useEphemeralOSDisk().map({ args0 -> args0 }).orElse(null),
            useTempDataDisk = javaType.useTempDataDisk().map({ args0 -> args0 }).orElse(null),
            vmExtensions = javaType.vmExtensions().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.servicefabric.kotlin.outputs.VMSSExtensionResponse.Companion.toKotlin(args0)
                })
            }),
            vmImageOffer = javaType.vmImageOffer().map({ args0 -> args0 }).orElse(null),
            vmImagePlan = javaType.vmImagePlan().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.servicefabric.kotlin.outputs.VmImagePlanResponse.Companion.toKotlin(args0)
                })
            }).orElse(null),
            vmImagePublisher = javaType.vmImagePublisher().map({ args0 -> args0 }).orElse(null),
            vmImageResourceId = javaType.vmImageResourceId().map({ args0 -> args0 }).orElse(null),
            vmImageSku = javaType.vmImageSku().map({ args0 -> args0 }).orElse(null),
            vmImageVersion = javaType.vmImageVersion().map({ args0 -> args0 }).orElse(null),
            vmInstanceCount = javaType.vmInstanceCount(),
            vmManagedIdentity = javaType.vmManagedIdentity().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.servicefabric.kotlin.outputs.VmManagedIdentityResponse.Companion.toKotlin(args0)
                })
            }).orElse(null),
            vmSecrets = javaType.vmSecrets().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.servicefabric.kotlin.outputs.VaultSecretGroupResponse.Companion.toKotlin(args0)
                })
            }),
            vmSetupActions = javaType.vmSetupActions().map({ args0 -> args0 }),
            vmSharedGalleryImageId = javaType.vmSharedGalleryImageId().map({ args0 -> args0 }).orElse(null),
            vmSize = javaType.vmSize().map({ args0 -> args0 }).orElse(null),
            zones = javaType.zones().map({ args0 -> args0 }),
        )
    }
}
