@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.servicefabric.kotlin.outputs

import kotlin.Boolean
import kotlin.Suppress
import kotlin.collections.List

/**
 * Describes the result of the request to list Managed VM Sizes for Service Fabric Managed Clusters.
 * @property baseResourceStatus List of Managed VM Sizes for Service Fabric Managed Clusters.
 * @property isClusterZoneResilient URL to get the next set of Managed VM Sizes if there are any.
 */
public data class GetmanagedAzResiliencyStatusResult(
    public val baseResourceStatus: List<ResourceAzStatusResponse>? = null,
    public val isClusterZoneResilient: Boolean,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.servicefabric.outputs.GetmanagedAzResiliencyStatusResult): GetmanagedAzResiliencyStatusResult = GetmanagedAzResiliencyStatusResult(
            baseResourceStatus = javaType.baseResourceStatus().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.servicefabric.kotlin.outputs.ResourceAzStatusResponse.Companion.toKotlin(args0)
                })
            }),
            isClusterZoneResilient = javaType.isClusterZoneResilient(),
        )
    }
}
