@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.servicefabric.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 * IPTag associated with the object.
 * @property ipTagType The IP tag type.
 * @property tag The value of the IP tag.
 */
public data class IPTagResponse(
    public val ipTagType: String,
    public val tag: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.servicefabric.outputs.IPTagResponse): IPTagResponse = IPTagResponse(
            ipTagType = javaType.ipTagType(),
            tag = javaType.tag(),
        )
    }
}
