@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.servicefabric.kotlin.outputs

import kotlin.Int
import kotlin.String
import kotlin.Suppress

/**
 * Describes a load balancing rule.
 * @property backendPort The port used for internal connections on the endpoint. Acceptable values are between 1 and 65535.
 * @property frontendPort The port for the external endpoint. Port numbers for each rule must be unique within the Load Balancer. Acceptable values are between 1 and 65534.
 * @property loadDistribution The load distribution policy for this rule.
 * @property probePort The prob port used by the load balancing rule. Acceptable values are between 1 and 65535.
 * @property probeProtocol the reference to the load balancer probe used by the load balancing rule.
 * @property probeRequestPath The probe request path. Only supported for HTTP/HTTPS probes.
 * @property protocol The reference to the transport protocol used by the load balancing rule.
 */
public data class LoadBalancingRuleResponse(
    public val backendPort: Int,
    public val frontendPort: Int,
    public val loadDistribution: String? = null,
    public val probePort: Int? = null,
    public val probeProtocol: String,
    public val probeRequestPath: String? = null,
    public val protocol: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.servicefabric.outputs.LoadBalancingRuleResponse): LoadBalancingRuleResponse = LoadBalancingRuleResponse(
            backendPort = javaType.backendPort(),
            frontendPort = javaType.frontendPort(),
            loadDistribution = javaType.loadDistribution().map({ args0 -> args0 }).orElse(null),
            probePort = javaType.probePort().map({ args0 -> args0 }).orElse(null),
            probeProtocol = javaType.probeProtocol(),
            probeRequestPath = javaType.probeRequestPath().map({ args0 -> args0 }).orElse(null),
            protocol = javaType.protocol(),
        )
    }
}
