@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.servicefabric.kotlin.outputs

import kotlin.String
import kotlin.Suppress
import kotlin.collections.List

/**
 * Describes the named partition scheme of the service.
 * @property names Array for the names of the partitions.
 * @property partitionScheme Enumerates the ways that a service can be partitioned.
 * Expected value is 'Named'.
 */
public data class NamedPartitionSchemeResponse(
    public val names: List<String>,
    public val partitionScheme: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.servicefabric.outputs.NamedPartitionSchemeResponse): NamedPartitionSchemeResponse = NamedPartitionSchemeResponse(
            names = javaType.names().map({ args0 -> args0 }),
            partitionScheme = javaType.partitionScheme(),
        )
    }
}
