@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.servicefabric.kotlin.outputs

import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List

/**
 * Describes a network security rule.
 * @property access The network traffic is allowed or denied.
 * @property description Network security rule description.
 * @property destinationAddressPrefix The destination address prefix. CIDR or destination IP range. Asterisk '*' can also be used to match all source IPs. Default tags such as 'VirtualNetwork', 'AzureLoadBalancer' and 'Internet' can also be used.
 * @property destinationAddressPrefixes The destination address prefixes. CIDR or destination IP ranges.
 * @property destinationPortRange he destination port or range. Integer or range between 0 and 65535. Asterisk '*' can also be used to match all ports.
 * @property destinationPortRanges The destination port ranges.
 * @property direction Network security rule direction.
 * @property name Network security rule name.
 * @property priority The priority of the rule. The value can be in the range 1000 to 3000. Values outside this range are reserved for Service Fabric ManagerCluster Resource Provider. The priority number must be unique for each rule in the collection. The lower the priority number, the higher the priority of the rule.
 * @property protocol Network protocol this rule applies to.
 * @property sourceAddressPrefix The CIDR or source IP range. Asterisk '*' can also be used to match all source IPs. Default tags such as 'VirtualNetwork', 'AzureLoadBalancer' and 'Internet' can also be used. If this is an ingress rule, specifies where network traffic originates from.
 * @property sourceAddressPrefixes The CIDR or source IP ranges.
 * @property sourcePortRange The source port or range. Integer or range between 0 and 65535. Asterisk '*' can also be used to match all ports.
 * @property sourcePortRanges The source port ranges.
 */
public data class NetworkSecurityRuleResponse(
    public val access: String,
    public val description: String? = null,
    public val destinationAddressPrefix: String? = null,
    public val destinationAddressPrefixes: List<String>? = null,
    public val destinationPortRange: String? = null,
    public val destinationPortRanges: List<String>? = null,
    public val direction: String,
    public val name: String,
    public val priority: Int,
    public val protocol: String,
    public val sourceAddressPrefix: String? = null,
    public val sourceAddressPrefixes: List<String>? = null,
    public val sourcePortRange: String? = null,
    public val sourcePortRanges: List<String>? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.servicefabric.outputs.NetworkSecurityRuleResponse): NetworkSecurityRuleResponse = NetworkSecurityRuleResponse(
            access = javaType.access(),
            description = javaType.description().map({ args0 -> args0 }).orElse(null),
            destinationAddressPrefix = javaType.destinationAddressPrefix().map({ args0 -> args0 }).orElse(null),
            destinationAddressPrefixes = javaType.destinationAddressPrefixes().map({ args0 -> args0 }),
            destinationPortRange = javaType.destinationPortRange().map({ args0 -> args0 }).orElse(null),
            destinationPortRanges = javaType.destinationPortRanges().map({ args0 -> args0 }),
            direction = javaType.direction(),
            name = javaType.name(),
            priority = javaType.priority(),
            protocol = javaType.protocol(),
            sourceAddressPrefix = javaType.sourceAddressPrefix().map({ args0 -> args0 }).orElse(null),
            sourceAddressPrefixes = javaType.sourceAddressPrefixes().map({ args0 -> args0 }),
            sourcePortRange = javaType.sourcePortRange().map({ args0 -> args0 }).orElse(null),
            sourcePortRanges = javaType.sourcePortRanges().map({ args0 -> args0 }),
        )
    }
}
