@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.servicefabric.kotlin.outputs

import kotlin.Boolean
import kotlin.String
import kotlin.Suppress

/**
 * Describes Az Resiliency status of Base resources
 * @property isZoneResilient VM Size name.
 * @property resourceName VM Size properties.
 * @property resourceType VM Size id.
 */
public data class ResourceAzStatusResponse(
    public val isZoneResilient: Boolean,
    public val resourceName: String,
    public val resourceType: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.servicefabric.outputs.ResourceAzStatusResponse): ResourceAzStatusResponse = ResourceAzStatusResponse(
            isZoneResilient = javaType.isZoneResilient(),
            resourceName = javaType.resourceName(),
            resourceType = javaType.resourceType(),
        )
    }
}
