@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.servicefabric.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 * Describes the policy to be used for placement of a Service Fabric service where a particular fault or upgrade domain should not be used for placement of the instances or replicas of that service.
 * @property domainName The name of the domain that should not be used for placement.
 * @property type The type of placement policy for a service fabric service. Following are the possible values.
 * Expected value is 'InvalidDomain'.
 */
public data class ServicePlacementInvalidDomainPolicyResponse(
    public val domainName: String,
    public val type: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.servicefabric.outputs.ServicePlacementInvalidDomainPolicyResponse): ServicePlacementInvalidDomainPolicyResponse = ServicePlacementInvalidDomainPolicyResponse(
            domainName = javaType.domainName(),
            type = javaType.type(),
        )
    }
}
