@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.servicefabric.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 * Describes the policy to be used for placement of a Service Fabric service where the instances or replicas of that service must be placed in a particular domain.
 * @property domainName The name of the domain that should used for placement as per this policy.
 * @property type The type of placement policy for a service fabric service. Following are the possible values.
 * Expected value is 'RequiredDomain'.
 */
public data class ServicePlacementRequiredDomainPolicyResponse(
    public val domainName: String,
    public val type: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.servicefabric.outputs.ServicePlacementRequiredDomainPolicyResponse): ServicePlacementRequiredDomainPolicyResponse = ServicePlacementRequiredDomainPolicyResponse(
            domainName = javaType.domainName(),
            type = javaType.type(),
        )
    }
}
