@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.servicefabric.kotlin.outputs

import kotlin.Any
import kotlin.Boolean
import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List

/**
 * The properties of a stateful service resource.
 * @property correlationScheme A list that describes the correlation of the service with other services.
 * @property defaultMoveCost Specifies the move cost for the service.
 * @property hasPersistedState A flag indicating whether this is a persistent service which stores states on the local disk. If it is then the value of this property is true, if not it is false.
 * @property minReplicaSetSize The minimum replica set size as a number.
 * @property partitionDescription Describes how the service is partitioned.
 * @property placementConstraints The placement constraints as a string. Placement constraints are boolean expressions on node properties and allow for restricting a service to particular nodes based on the service requirements. For example, to place a service on nodes where NodeType is blue specify the following: "NodeColor == blue)".
 * @property provisioningState The current deployment or provisioning state, which only appears in the response
 * @property quorumLossWaitDuration The maximum duration for which a partition is allowed to be in a state of quorum loss, represented in ISO 8601 format "hh:mm:ss".
 * @property replicaRestartWaitDuration The duration between when a replica goes down and when a new replica is created, represented in ISO 8601 format "hh:mm:ss".
 * @property scalingPolicies Scaling policies for this service.
 * @property serviceDnsName Dns name used for the service. If this is specified, then the DNS name can be used to return the IP addresses of service endpoints for application layer protocols (e.g., HTTP).
 * When updating serviceDnsName, old name may be temporarily resolvable. However, rely on new name.
 * When removing serviceDnsName, removed name may temporarily be resolvable. Do not rely on the name being unresolvable.
 * @property serviceKind The kind of service (Stateless or Stateful).
 * Expected value is 'Stateful'.
 * @property serviceLoadMetrics The service load metrics is given as an array of ServiceLoadMetric objects.
 * @property servicePackageActivationMode The activation Mode of the service package
 * @property servicePlacementPolicies A list that describes the correlation of the service with other services.
 * @property servicePlacementTimeLimit The duration for which replicas can stay InBuild before reporting that build is stuck, represented in ISO 8601 format "hh:mm:ss".
 * @property serviceTypeName The name of the service type
 * @property standByReplicaKeepDuration The definition on how long StandBy replicas should be maintained before being removed, represented in ISO 8601 format "hh:mm:ss".
 * @property targetReplicaSetSize The target replica set size as a number.
 */
public data class StatefulServicePropertiesResponse(
    public val correlationScheme: List<ServiceCorrelationResponse>? = null,
    public val defaultMoveCost: String? = null,
    public val hasPersistedState: Boolean? = null,
    public val minReplicaSetSize: Int? = null,
    public val partitionDescription: Any,
    public val placementConstraints: String? = null,
    public val provisioningState: String,
    public val quorumLossWaitDuration: String? = null,
    public val replicaRestartWaitDuration: String? = null,
    public val scalingPolicies: List<ScalingPolicyResponse>? = null,
    public val serviceDnsName: String? = null,
    public val serviceKind: String,
    public val serviceLoadMetrics: List<ServiceLoadMetricResponse>? = null,
    public val servicePackageActivationMode: String? = null,
    public val servicePlacementPolicies: List<Any>? = null,
    public val servicePlacementTimeLimit: String? = null,
    public val serviceTypeName: String,
    public val standByReplicaKeepDuration: String? = null,
    public val targetReplicaSetSize: Int? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.servicefabric.outputs.StatefulServicePropertiesResponse): StatefulServicePropertiesResponse = StatefulServicePropertiesResponse(
            correlationScheme = javaType.correlationScheme().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.servicefabric.kotlin.outputs.ServiceCorrelationResponse.Companion.toKotlin(args0)
                })
            }),
            defaultMoveCost = javaType.defaultMoveCost().map({ args0 -> args0 }).orElse(null),
            hasPersistedState = javaType.hasPersistedState().map({ args0 -> args0 }).orElse(null),
            minReplicaSetSize = javaType.minReplicaSetSize().map({ args0 -> args0 }).orElse(null),
            partitionDescription = javaType.partitionDescription(),
            placementConstraints = javaType.placementConstraints().map({ args0 -> args0 }).orElse(null),
            provisioningState = javaType.provisioningState(),
            quorumLossWaitDuration = javaType.quorumLossWaitDuration().map({ args0 -> args0 }).orElse(null),
            replicaRestartWaitDuration = javaType.replicaRestartWaitDuration().map({ args0 ->
                args0
            }).orElse(null),
            scalingPolicies = javaType.scalingPolicies().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.servicefabric.kotlin.outputs.ScalingPolicyResponse.Companion.toKotlin(args0)
                })
            }),
            serviceDnsName = javaType.serviceDnsName().map({ args0 -> args0 }).orElse(null),
            serviceKind = javaType.serviceKind(),
            serviceLoadMetrics = javaType.serviceLoadMetrics().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.servicefabric.kotlin.outputs.ServiceLoadMetricResponse.Companion.toKotlin(args0)
                })
            }),
            servicePackageActivationMode = javaType.servicePackageActivationMode().map({ args0 ->
                args0
            }).orElse(null),
            servicePlacementPolicies = javaType.servicePlacementPolicies().map({ args0 -> args0 }),
            servicePlacementTimeLimit = javaType.servicePlacementTimeLimit().map({ args0 ->
                args0
            }).orElse(null),
            serviceTypeName = javaType.serviceTypeName(),
            standByReplicaKeepDuration = javaType.standByReplicaKeepDuration().map({ args0 ->
                args0
            }).orElse(null),
            targetReplicaSetSize = javaType.targetReplicaSetSize().map({ args0 -> args0 }).orElse(null),
        )
    }
}
