@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.servicefabricmesh.kotlin

import com.pulumi.azurenative.servicefabricmesh.kotlin.outputs.SecretResourcePropertiesResponse
import com.pulumi.azurenative.servicefabricmesh.kotlin.outputs.SecretResourcePropertiesResponse.Companion.toKotlin
import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.Map

/**
 * Builder for [Secret].
 */
@PulumiTagMarker
public class SecretResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: SecretArgs = SecretArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend SecretArgsBuilder.() -> Unit) {
        val builder = SecretArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.CustomResourceOptions.opts(block)
    }

    internal fun build(): Secret {
        val builtJavaResource = com.pulumi.azurenative.servicefabricmesh.Secret(
            this.name,
            this.args.toJava(),
            this.opts.toJava(),
        )
        return Secret(builtJavaResource)
    }
}

/**
 * This type describes a secret resource.
 * Azure REST API version: 2018-09-01-preview. Prior API version in Azure Native 1.x: 2018-09-01-preview.
 * ## Example Usage
 * ### CreateOrUpdateSecret
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var secret = new AzureNative.ServiceFabricMesh.Secret("secret", new()
 *     {
 *         Location = "EastUS",
 *         Properties = null,
 *         ResourceGroupName = "sbz_demo",
 *         SecretResourceName = "dbConnectionString",
 *         Tags = null,
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/servicefabricmesh/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := servicefabricmesh.NewSecret(ctx, "secret", &servicefabricmesh.SecretArgs{
 * 			Location:           pulumi.String("EastUS"),
 * 			Properties:         nil,
 * 			ResourceGroupName:  pulumi.String("sbz_demo"),
 * 			SecretResourceName: pulumi.String("dbConnectionString"),
 * 			Tags:               nil,
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.servicefabricmesh.Secret;
 * import com.pulumi.azurenative.servicefabricmesh.SecretArgs;
 * import com.pulumi.azurenative.servicefabricmesh.inputs.SecretResourcePropertiesArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var secret = new Secret("secret", SecretArgs.builder()
 *             .location("EastUS")
 *             .properties()
 *             .resourceGroupName("sbz_demo")
 *             .secretResourceName("dbConnectionString")
 *             .tags()
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:servicefabricmesh:Secret dbConnectionString /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.ServiceFabricMesh/secrets/{secretResourceName}
 * ```
 */
public class Secret internal constructor(
    override val javaResource: com.pulumi.azurenative.servicefabricmesh.Secret,
) : KotlinCustomResource(javaResource, SecretMapper) {
    /**
     * The geo-location where the resource lives
     */
    public val location: Output<String>
        get() = javaResource.location().applyValue({ args0 -> args0 })

    /**
     * The name of the resource
     */
    public val name: Output<String>
        get() = javaResource.name().applyValue({ args0 -> args0 })

    /**
     * Describes the properties of a secret resource.
     */
    public val properties: Output<SecretResourcePropertiesResponse>
        get() = javaResource.properties().applyValue({ args0 -> args0.let({ args0 -> toKotlin(args0) }) })

    /**
     * Resource tags.
     */
    public val tags: Output<Map<String, String>>?
        get() = javaResource.tags().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 ->
                    args0.key.to(args0.value)
                }).toMap()
            }).orElse(null)
        })

    /**
     * The type of the resource. Ex- Microsoft.Compute/virtualMachines or Microsoft.Storage/storageAccounts.
     */
    public val type: Output<String>
        get() = javaResource.type().applyValue({ args0 -> args0 })
}

public object SecretMapper : ResourceMapper<Secret> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.azurenative.servicefabricmesh.Secret::class == javaResource::class

    override fun map(javaResource: Resource): Secret = Secret(
        javaResource as
            com.pulumi.azurenative.servicefabricmesh.Secret,
    )
}

/**
 * @see [Secret].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [Secret].
 */
public suspend fun secret(name: String, block: suspend SecretResourceBuilder.() -> Unit): Secret {
    val builder = SecretResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [Secret].
 * @param name The _unique_ name of the resulting resource.
 */
public fun secret(name: String): Secret {
    val builder = SecretResourceBuilder()
    builder.name(name)
    return builder.build()
}
