@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.servicefabricmesh.kotlin

import com.pulumi.azurenative.servicefabricmesh.ServicefabricmeshFunctions.getApplicationPlain
import com.pulumi.azurenative.servicefabricmesh.ServicefabricmeshFunctions.getGatewayPlain
import com.pulumi.azurenative.servicefabricmesh.ServicefabricmeshFunctions.getNetworkPlain
import com.pulumi.azurenative.servicefabricmesh.ServicefabricmeshFunctions.getSecretPlain
import com.pulumi.azurenative.servicefabricmesh.ServicefabricmeshFunctions.getSecretValuePlain
import com.pulumi.azurenative.servicefabricmesh.ServicefabricmeshFunctions.getVolumePlain
import com.pulumi.azurenative.servicefabricmesh.ServicefabricmeshFunctions.listSecretValuePlain
import com.pulumi.azurenative.servicefabricmesh.kotlin.inputs.GetApplicationPlainArgs
import com.pulumi.azurenative.servicefabricmesh.kotlin.inputs.GetApplicationPlainArgsBuilder
import com.pulumi.azurenative.servicefabricmesh.kotlin.inputs.GetGatewayPlainArgs
import com.pulumi.azurenative.servicefabricmesh.kotlin.inputs.GetGatewayPlainArgsBuilder
import com.pulumi.azurenative.servicefabricmesh.kotlin.inputs.GetNetworkPlainArgs
import com.pulumi.azurenative.servicefabricmesh.kotlin.inputs.GetNetworkPlainArgsBuilder
import com.pulumi.azurenative.servicefabricmesh.kotlin.inputs.GetSecretPlainArgs
import com.pulumi.azurenative.servicefabricmesh.kotlin.inputs.GetSecretPlainArgsBuilder
import com.pulumi.azurenative.servicefabricmesh.kotlin.inputs.GetSecretValuePlainArgs
import com.pulumi.azurenative.servicefabricmesh.kotlin.inputs.GetSecretValuePlainArgsBuilder
import com.pulumi.azurenative.servicefabricmesh.kotlin.inputs.GetVolumePlainArgs
import com.pulumi.azurenative.servicefabricmesh.kotlin.inputs.GetVolumePlainArgsBuilder
import com.pulumi.azurenative.servicefabricmesh.kotlin.inputs.ListSecretValuePlainArgs
import com.pulumi.azurenative.servicefabricmesh.kotlin.inputs.ListSecretValuePlainArgsBuilder
import com.pulumi.azurenative.servicefabricmesh.kotlin.outputs.GetApplicationResult
import com.pulumi.azurenative.servicefabricmesh.kotlin.outputs.GetGatewayResult
import com.pulumi.azurenative.servicefabricmesh.kotlin.outputs.GetNetworkResult
import com.pulumi.azurenative.servicefabricmesh.kotlin.outputs.GetSecretResult
import com.pulumi.azurenative.servicefabricmesh.kotlin.outputs.GetSecretValueResult
import com.pulumi.azurenative.servicefabricmesh.kotlin.outputs.GetVolumeResult
import com.pulumi.azurenative.servicefabricmesh.kotlin.outputs.ListSecretValueResult
import kotlinx.coroutines.future.await
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import com.pulumi.azurenative.servicefabricmesh.kotlin.outputs.GetApplicationResult.Companion.toKotlin as getApplicationResultToKotlin
import com.pulumi.azurenative.servicefabricmesh.kotlin.outputs.GetGatewayResult.Companion.toKotlin as getGatewayResultToKotlin
import com.pulumi.azurenative.servicefabricmesh.kotlin.outputs.GetNetworkResult.Companion.toKotlin as getNetworkResultToKotlin
import com.pulumi.azurenative.servicefabricmesh.kotlin.outputs.GetSecretResult.Companion.toKotlin as getSecretResultToKotlin
import com.pulumi.azurenative.servicefabricmesh.kotlin.outputs.GetSecretValueResult.Companion.toKotlin as getSecretValueResultToKotlin
import com.pulumi.azurenative.servicefabricmesh.kotlin.outputs.GetVolumeResult.Companion.toKotlin as getVolumeResultToKotlin
import com.pulumi.azurenative.servicefabricmesh.kotlin.outputs.ListSecretValueResult.Companion.toKotlin as listSecretValueResultToKotlin

public object ServicefabricmeshFunctions {
    /**
     * Gets the information about the application resource with the given name. The information include the description and other properties of the application.
     * Azure REST API version: 2018-09-01-preview.
     * Other available API versions: 2018-07-01-preview.
     * @param argument null
     * @return This type describes an application resource.
     */
    public suspend fun getApplication(argument: GetApplicationPlainArgs): GetApplicationResult =
        getApplicationResultToKotlin(getApplicationPlain(argument.toJava()).await())

    /**
     * @see [getApplication].
     * @param applicationResourceName The identity of the application.
     * @param resourceGroupName Azure resource group name
     * @return This type describes an application resource.
     */
    public suspend fun getApplication(applicationResourceName: String, resourceGroupName: String): GetApplicationResult {
        val argument = GetApplicationPlainArgs(
            applicationResourceName = applicationResourceName,
            resourceGroupName = resourceGroupName,
        )
        return getApplicationResultToKotlin(getApplicationPlain(argument.toJava()).await())
    }

    /**
     * @see [getApplication].
     * @param argument Builder for [com&#46;pulumi&#46;azurenative&#46;servicefabricmesh&#46;kotlin&#46;inputs&#46;GetApplicationPlainArgs].
     * @return This type describes an application resource.
     */
    public suspend fun getApplication(argument: suspend GetApplicationPlainArgsBuilder.() -> Unit): GetApplicationResult {
        val builder = GetApplicationPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getApplicationResultToKotlin(getApplicationPlain(builtArgument.toJava()).await())
    }

    /**
     * Gets the information about the gateway resource with the given name. The information include the description and other properties of the gateway.
     * Azure REST API version: 2018-09-01-preview.
     * @param argument null
     * @return This type describes a gateway resource.
     */
    public suspend fun getGateway(argument: GetGatewayPlainArgs): GetGatewayResult =
        getGatewayResultToKotlin(getGatewayPlain(argument.toJava()).await())

    /**
     * @see [getGateway].
     * @param gatewayResourceName The identity of the gateway.
     * @param resourceGroupName Azure resource group name
     * @return This type describes a gateway resource.
     */
    public suspend fun getGateway(gatewayResourceName: String, resourceGroupName: String): GetGatewayResult {
        val argument = GetGatewayPlainArgs(
            gatewayResourceName = gatewayResourceName,
            resourceGroupName = resourceGroupName,
        )
        return getGatewayResultToKotlin(getGatewayPlain(argument.toJava()).await())
    }

    /**
     * @see [getGateway].
     * @param argument Builder for [com&#46;pulumi&#46;azurenative&#46;servicefabricmesh&#46;kotlin&#46;inputs&#46;GetGatewayPlainArgs].
     * @return This type describes a gateway resource.
     */
    public suspend fun getGateway(argument: suspend GetGatewayPlainArgsBuilder.() -> Unit): GetGatewayResult {
        val builder = GetGatewayPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getGatewayResultToKotlin(getGatewayPlain(builtArgument.toJava()).await())
    }

    /**
     * Gets the information about the network resource with the given name. The information include the description and other properties of the network.
     * Azure REST API version: 2018-09-01-preview.
     * Other available API versions: 2018-07-01-preview.
     * @param argument null
     * @return This type describes a network resource.
     */
    public suspend fun getNetwork(argument: GetNetworkPlainArgs): GetNetworkResult =
        getNetworkResultToKotlin(getNetworkPlain(argument.toJava()).await())

    /**
     * @see [getNetwork].
     * @param networkResourceName The identity of the network.
     * @param resourceGroupName Azure resource group name
     * @return This type describes a network resource.
     */
    public suspend fun getNetwork(networkResourceName: String, resourceGroupName: String): GetNetworkResult {
        val argument = GetNetworkPlainArgs(
            networkResourceName = networkResourceName,
            resourceGroupName = resourceGroupName,
        )
        return getNetworkResultToKotlin(getNetworkPlain(argument.toJava()).await())
    }

    /**
     * @see [getNetwork].
     * @param argument Builder for [com&#46;pulumi&#46;azurenative&#46;servicefabricmesh&#46;kotlin&#46;inputs&#46;GetNetworkPlainArgs].
     * @return This type describes a network resource.
     */
    public suspend fun getNetwork(argument: suspend GetNetworkPlainArgsBuilder.() -> Unit): GetNetworkResult {
        val builder = GetNetworkPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getNetworkResultToKotlin(getNetworkPlain(builtArgument.toJava()).await())
    }

    /**
     * Gets the information about the secret resource with the given name. The information include the description and other properties of the secret.
     * Azure REST API version: 2018-09-01-preview.
     * @param argument null
     * @return This type describes a secret resource.
     */
    public suspend fun getSecret(argument: GetSecretPlainArgs): GetSecretResult =
        getSecretResultToKotlin(getSecretPlain(argument.toJava()).await())

    /**
     * @see [getSecret].
     * @param resourceGroupName Azure resource group name
     * @param secretResourceName The name of the secret resource.
     * @return This type describes a secret resource.
     */
    public suspend fun getSecret(resourceGroupName: String, secretResourceName: String): GetSecretResult {
        val argument = GetSecretPlainArgs(
            resourceGroupName = resourceGroupName,
            secretResourceName = secretResourceName,
        )
        return getSecretResultToKotlin(getSecretPlain(argument.toJava()).await())
    }

    /**
     * @see [getSecret].
     * @param argument Builder for [com&#46;pulumi&#46;azurenative&#46;servicefabricmesh&#46;kotlin&#46;inputs&#46;GetSecretPlainArgs].
     * @return This type describes a secret resource.
     */
    public suspend fun getSecret(argument: suspend GetSecretPlainArgsBuilder.() -> Unit): GetSecretResult {
        val builder = GetSecretPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getSecretResultToKotlin(getSecretPlain(builtArgument.toJava()).await())
    }

    /**
     * Get the information about the specified named secret value resources. The information does not include the actual value of the secret.
     * Azure REST API version: 2018-09-01-preview.
     * @param argument null
     * @return This type describes a value of a secret resource. The name of this resource is the version identifier corresponding to this secret value.
     */
    public suspend fun getSecretValue(argument: GetSecretValuePlainArgs): GetSecretValueResult =
        getSecretValueResultToKotlin(getSecretValuePlain(argument.toJava()).await())

    /**
     * @see [getSecretValue].
     * @param resourceGroupName Azure resource group name
     * @param secretResourceName The name of the secret resource.
     * @param secretValueResourceName The name of the secret resource value which is typically the version identifier for the value.
     * @return This type describes a value of a secret resource. The name of this resource is the version identifier corresponding to this secret value.
     */
    public suspend fun getSecretValue(
        resourceGroupName: String,
        secretResourceName: String,
        secretValueResourceName: String,
    ): GetSecretValueResult {
        val argument = GetSecretValuePlainArgs(
            resourceGroupName = resourceGroupName,
            secretResourceName = secretResourceName,
            secretValueResourceName = secretValueResourceName,
        )
        return getSecretValueResultToKotlin(getSecretValuePlain(argument.toJava()).await())
    }

    /**
     * @see [getSecretValue].
     * @param argument Builder for [com&#46;pulumi&#46;azurenative&#46;servicefabricmesh&#46;kotlin&#46;inputs&#46;GetSecretValuePlainArgs].
     * @return This type describes a value of a secret resource. The name of this resource is the version identifier corresponding to this secret value.
     */
    public suspend fun getSecretValue(argument: suspend GetSecretValuePlainArgsBuilder.() -> Unit): GetSecretValueResult {
        val builder = GetSecretValuePlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getSecretValueResultToKotlin(getSecretValuePlain(builtArgument.toJava()).await())
    }

    /**
     * Gets the information about the volume resource with the given name. The information include the description and other properties of the volume.
     * Azure REST API version: 2018-09-01-preview.
     * Other available API versions: 2018-07-01-preview.
     * @param argument null
     * @return This type describes a volume resource.
     */
    public suspend fun getVolume(argument: GetVolumePlainArgs): GetVolumeResult =
        getVolumeResultToKotlin(getVolumePlain(argument.toJava()).await())

    /**
     * @see [getVolume].
     * @param resourceGroupName Azure resource group name
     * @param volumeResourceName The identity of the volume.
     * @return This type describes a volume resource.
     */
    public suspend fun getVolume(resourceGroupName: String, volumeResourceName: String): GetVolumeResult {
        val argument = GetVolumePlainArgs(
            resourceGroupName = resourceGroupName,
            volumeResourceName = volumeResourceName,
        )
        return getVolumeResultToKotlin(getVolumePlain(argument.toJava()).await())
    }

    /**
     * @see [getVolume].
     * @param argument Builder for [com&#46;pulumi&#46;azurenative&#46;servicefabricmesh&#46;kotlin&#46;inputs&#46;GetVolumePlainArgs].
     * @return This type describes a volume resource.
     */
    public suspend fun getVolume(argument: suspend GetVolumePlainArgsBuilder.() -> Unit): GetVolumeResult {
        val builder = GetVolumePlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getVolumeResultToKotlin(getVolumePlain(builtArgument.toJava()).await())
    }

    /**
     * Lists the decrypted value of the specified named value of the secret resource. This is a privileged operation.
     * Azure REST API version: 2018-09-01-preview.
     * @param argument null
     * @return This type represents the unencrypted value of the secret.
     */
    public suspend fun listSecretValue(argument: ListSecretValuePlainArgs): ListSecretValueResult =
        listSecretValueResultToKotlin(listSecretValuePlain(argument.toJava()).await())

    /**
     * @see [listSecretValue].
     * @param resourceGroupName Azure resource group name
     * @param secretResourceName The name of the secret resource.
     * @param secretValueResourceName The name of the secret resource value which is typically the version identifier for the value.
     * @return This type represents the unencrypted value of the secret.
     */
    public suspend fun listSecretValue(
        resourceGroupName: String,
        secretResourceName: String,
        secretValueResourceName: String,
    ): ListSecretValueResult {
        val argument = ListSecretValuePlainArgs(
            resourceGroupName = resourceGroupName,
            secretResourceName = secretResourceName,
            secretValueResourceName = secretValueResourceName,
        )
        return listSecretValueResultToKotlin(listSecretValuePlain(argument.toJava()).await())
    }

    /**
     * @see [listSecretValue].
     * @param argument Builder for [com&#46;pulumi&#46;azurenative&#46;servicefabricmesh&#46;kotlin&#46;inputs&#46;ListSecretValuePlainArgs].
     * @return This type represents the unencrypted value of the secret.
     */
    public suspend fun listSecretValue(argument: suspend ListSecretValuePlainArgsBuilder.() -> Unit): ListSecretValueResult {
        val builder = ListSecretValuePlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return listSecretValueResultToKotlin(listSecretValuePlain(builtArgument.toJava()).await())
    }
}
