@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.servicefabricmesh.kotlin.enums

import com.pulumi.kotlin.ConvertibleToJava
import kotlin.Suppress

/**
 * The operation system required by the code in service.
 */
public enum class OperatingSystemType(
    public val javaValue: com.pulumi.azurenative.servicefabricmesh.enums.OperatingSystemType,
) : ConvertibleToJava<com.pulumi.azurenative.servicefabricmesh.enums.OperatingSystemType> {
    /**
     * The required operating system is Linux.
     */
    Linux(com.pulumi.azurenative.servicefabricmesh.enums.OperatingSystemType.Linux),

    /**
     * The required operating system is Windows.
     */
    Windows(com.pulumi.azurenative.servicefabricmesh.enums.OperatingSystemType.Windows),
    ;

    override fun toJava(): com.pulumi.azurenative.servicefabricmesh.enums.OperatingSystemType =
        javaValue

    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.servicefabricmesh.enums.OperatingSystemType): OperatingSystemType = OperatingSystemType.values().first { it.javaValue == javaType }
    }
}
