@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.servicefabricmesh.kotlin.inputs

import com.pulumi.azurenative.servicefabricmesh.inputs.AddRemoveReplicaScalingMechanismArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * Describes the horizontal auto scaling mechanism that adds or removes replicas (containers or container groups).
 * @property kind Enumerates the mechanisms for auto scaling.
 * Expected value is 'AddRemoveReplica'.
 * @property maxCount Maximum number of containers (scale up won't be performed above this number).
 * @property minCount Minimum number of containers (scale down won't be performed below this number).
 * @property scaleIncrement Each time auto scaling is performed, this number of containers will be added or removed.
 */
public data class AddRemoveReplicaScalingMechanismArgs(
    public val kind: Output<String>,
    public val maxCount: Output<Int>,
    public val minCount: Output<Int>,
    public val scaleIncrement: Output<Int>,
) :
    ConvertibleToJava<com.pulumi.azurenative.servicefabricmesh.inputs.AddRemoveReplicaScalingMechanismArgs> {
    override fun toJava(): com.pulumi.azurenative.servicefabricmesh.inputs.AddRemoveReplicaScalingMechanismArgs =
        com.pulumi.azurenative.servicefabricmesh.inputs.AddRemoveReplicaScalingMechanismArgs.builder()
            .kind(kind.applyValue({ args0 -> args0 }))
            .maxCount(maxCount.applyValue({ args0 -> args0 }))
            .minCount(minCount.applyValue({ args0 -> args0 }))
            .scaleIncrement(scaleIncrement.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [AddRemoveReplicaScalingMechanismArgs].
 */
@PulumiTagMarker
public class AddRemoveReplicaScalingMechanismArgsBuilder internal constructor() {
    private var kind: Output<String>? = null

    private var maxCount: Output<Int>? = null

    private var minCount: Output<Int>? = null

    private var scaleIncrement: Output<Int>? = null

    /**
     * @param value Enumerates the mechanisms for auto scaling.
     * Expected value is 'AddRemoveReplica'.
     */
    @JvmName("wchiublwutydtwrr")
    public suspend fun kind(`value`: Output<String>) {
        this.kind = value
    }

    /**
     * @param value Maximum number of containers (scale up won't be performed above this number).
     */
    @JvmName("ivllaxdecpcytgbw")
    public suspend fun maxCount(`value`: Output<Int>) {
        this.maxCount = value
    }

    /**
     * @param value Minimum number of containers (scale down won't be performed below this number).
     */
    @JvmName("jubpfaaugucgpcwk")
    public suspend fun minCount(`value`: Output<Int>) {
        this.minCount = value
    }

    /**
     * @param value Each time auto scaling is performed, this number of containers will be added or removed.
     */
    @JvmName("boonwemblhritsps")
    public suspend fun scaleIncrement(`value`: Output<Int>) {
        this.scaleIncrement = value
    }

    /**
     * @param value Enumerates the mechanisms for auto scaling.
     * Expected value is 'AddRemoveReplica'.
     */
    @JvmName("groilnjshhrrfwbb")
    public suspend fun kind(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.kind = mapped
    }

    /**
     * @param value Maximum number of containers (scale up won't be performed above this number).
     */
    @JvmName("piarovnaomoidtjj")
    public suspend fun maxCount(`value`: Int) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.maxCount = mapped
    }

    /**
     * @param value Minimum number of containers (scale down won't be performed below this number).
     */
    @JvmName("ukcwqjvqxxggkbvf")
    public suspend fun minCount(`value`: Int) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.minCount = mapped
    }

    /**
     * @param value Each time auto scaling is performed, this number of containers will be added or removed.
     */
    @JvmName("clrppouudbikgjlx")
    public suspend fun scaleIncrement(`value`: Int) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.scaleIncrement = mapped
    }

    internal fun build(): AddRemoveReplicaScalingMechanismArgs = AddRemoveReplicaScalingMechanismArgs(
        kind = kind ?: throw PulumiNullFieldException("kind"),
        maxCount = maxCount ?: throw PulumiNullFieldException("maxCount"),
        minCount = minCount ?: throw PulumiNullFieldException("minCount"),
        scaleIncrement = scaleIncrement ?: throw PulumiNullFieldException("scaleIncrement"),
    )
}
