@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.servicefabricmesh.kotlin.inputs

import com.pulumi.azurenative.servicefabricmesh.inputs.AutoScalingPolicyArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.jvm.JvmName

/**
 * Describes the auto scaling policy
 * @property mechanism The mechanism that is used to scale when auto scaling operation is invoked.
 * @property name The name of the auto scaling policy.
 * @property trigger Determines when auto scaling operation will be invoked.
 */
public data class AutoScalingPolicyArgs(
    public val mechanism: Output<AddRemoveReplicaScalingMechanismArgs>,
    public val name: Output<String>,
    public val trigger: Output<AverageLoadScalingTriggerArgs>,
) : ConvertibleToJava<com.pulumi.azurenative.servicefabricmesh.inputs.AutoScalingPolicyArgs> {
    override fun toJava(): com.pulumi.azurenative.servicefabricmesh.inputs.AutoScalingPolicyArgs =
        com.pulumi.azurenative.servicefabricmesh.inputs.AutoScalingPolicyArgs.builder()
            .mechanism(mechanism.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .name(name.applyValue({ args0 -> args0 }))
            .trigger(trigger.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) })).build()
}

/**
 * Builder for [AutoScalingPolicyArgs].
 */
@PulumiTagMarker
public class AutoScalingPolicyArgsBuilder internal constructor() {
    private var mechanism: Output<AddRemoveReplicaScalingMechanismArgs>? = null

    private var name: Output<String>? = null

    private var trigger: Output<AverageLoadScalingTriggerArgs>? = null

    /**
     * @param value The mechanism that is used to scale when auto scaling operation is invoked.
     */
    @JvmName("hkfmuvitneghcrnf")
    public suspend fun mechanism(`value`: Output<AddRemoveReplicaScalingMechanismArgs>) {
        this.mechanism = value
    }

    /**
     * @param value The name of the auto scaling policy.
     */
    @JvmName("yrbjmukoicijavpl")
    public suspend fun name(`value`: Output<String>) {
        this.name = value
    }

    /**
     * @param value Determines when auto scaling operation will be invoked.
     */
    @JvmName("wwbnsaglpckvemrw")
    public suspend fun trigger(`value`: Output<AverageLoadScalingTriggerArgs>) {
        this.trigger = value
    }

    /**
     * @param value The mechanism that is used to scale when auto scaling operation is invoked.
     */
    @JvmName("hxvqjuusdleqeeqj")
    public suspend fun mechanism(`value`: AddRemoveReplicaScalingMechanismArgs) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.mechanism = mapped
    }

    /**
     * @param argument The mechanism that is used to scale when auto scaling operation is invoked.
     */
    @JvmName("gjardtynvjfqifuy")
    public suspend fun mechanism(argument: suspend AddRemoveReplicaScalingMechanismArgsBuilder.() -> Unit) {
        val toBeMapped = AddRemoveReplicaScalingMechanismArgsBuilder().applySuspend {
            argument()
        }.build()
        val mapped = of(toBeMapped)
        this.mechanism = mapped
    }

    /**
     * @param value The name of the auto scaling policy.
     */
    @JvmName("mreuroavawmaahyl")
    public suspend fun name(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.name = mapped
    }

    /**
     * @param value Determines when auto scaling operation will be invoked.
     */
    @JvmName("oxrmwqqybjopmisb")
    public suspend fun trigger(`value`: AverageLoadScalingTriggerArgs) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.trigger = mapped
    }

    /**
     * @param argument Determines when auto scaling operation will be invoked.
     */
    @JvmName("wvimnbufnhcvhdpt")
    public suspend fun trigger(argument: suspend AverageLoadScalingTriggerArgsBuilder.() -> Unit) {
        val toBeMapped = AverageLoadScalingTriggerArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.trigger = mapped
    }

    internal fun build(): AutoScalingPolicyArgs = AutoScalingPolicyArgs(
        mechanism = mechanism ?: throw PulumiNullFieldException("mechanism"),
        name = name ?: throw PulumiNullFieldException("name"),
        trigger = trigger ?: throw PulumiNullFieldException("trigger"),
    )
}
