@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.servicefabricmesh.kotlin.inputs

import com.pulumi.azurenative.servicefabricmesh.inputs.DiagnosticsRefArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 * Reference to sinks in DiagnosticsDescription.
 * @property enabled Status of whether or not sinks are enabled.
 * @property sinkRefs List of sinks to be used if enabled. References the list of sinks in DiagnosticsDescription.
 */
public data class DiagnosticsRefArgs(
    public val enabled: Output<Boolean>? = null,
    public val sinkRefs: Output<List<String>>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.servicefabricmesh.inputs.DiagnosticsRefArgs> {
    override fun toJava(): com.pulumi.azurenative.servicefabricmesh.inputs.DiagnosticsRefArgs =
        com.pulumi.azurenative.servicefabricmesh.inputs.DiagnosticsRefArgs.builder()
            .enabled(enabled?.applyValue({ args0 -> args0 }))
            .sinkRefs(sinkRefs?.applyValue({ args0 -> args0.map({ args0 -> args0 }) })).build()
}

/**
 * Builder for [DiagnosticsRefArgs].
 */
@PulumiTagMarker
public class DiagnosticsRefArgsBuilder internal constructor() {
    private var enabled: Output<Boolean>? = null

    private var sinkRefs: Output<List<String>>? = null

    /**
     * @param value Status of whether or not sinks are enabled.
     */
    @JvmName("mjbgmbysltoltfdi")
    public suspend fun enabled(`value`: Output<Boolean>) {
        this.enabled = value
    }

    /**
     * @param value List of sinks to be used if enabled. References the list of sinks in DiagnosticsDescription.
     */
    @JvmName("sdprujsjgvkdlyuj")
    public suspend fun sinkRefs(`value`: Output<List<String>>) {
        this.sinkRefs = value
    }

    @JvmName("vgrgetqawvjaptvy")
    public suspend fun sinkRefs(vararg values: Output<String>) {
        this.sinkRefs = Output.all(values.asList())
    }

    /**
     * @param values List of sinks to be used if enabled. References the list of sinks in DiagnosticsDescription.
     */
    @JvmName("gkdgdyqdkphoohty")
    public suspend fun sinkRefs(values: List<Output<String>>) {
        this.sinkRefs = Output.all(values)
    }

    /**
     * @param value Status of whether or not sinks are enabled.
     */
    @JvmName("nbimicivtdxmibus")
    public suspend fun enabled(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.enabled = mapped
    }

    /**
     * @param value List of sinks to be used if enabled. References the list of sinks in DiagnosticsDescription.
     */
    @JvmName("hvbgwvcimjarjqgt")
    public suspend fun sinkRefs(`value`: List<String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.sinkRefs = mapped
    }

    /**
     * @param values List of sinks to be used if enabled. References the list of sinks in DiagnosticsDescription.
     */
    @JvmName("ykqphaqaftvsdkik")
    public suspend fun sinkRefs(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.sinkRefs = mapped
    }

    internal fun build(): DiagnosticsRefArgs = DiagnosticsRefArgs(
        enabled = enabled,
        sinkRefs = sinkRefs,
    )
}
