@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.servicefabricmesh.kotlin.inputs

import com.pulumi.azurenative.servicefabricmesh.inputs.EndpointPropertiesArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * Describes a container endpoint.
 * @property name The name of the endpoint.
 * @property port Port used by the container.
 */
public data class EndpointPropertiesArgs(
    public val name: Output<String>,
    public val port: Output<Int>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.servicefabricmesh.inputs.EndpointPropertiesArgs> {
    override fun toJava(): com.pulumi.azurenative.servicefabricmesh.inputs.EndpointPropertiesArgs =
        com.pulumi.azurenative.servicefabricmesh.inputs.EndpointPropertiesArgs.builder()
            .name(name.applyValue({ args0 -> args0 }))
            .port(port?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [EndpointPropertiesArgs].
 */
@PulumiTagMarker
public class EndpointPropertiesArgsBuilder internal constructor() {
    private var name: Output<String>? = null

    private var port: Output<Int>? = null

    /**
     * @param value The name of the endpoint.
     */
    @JvmName("peghtexqvckmfels")
    public suspend fun name(`value`: Output<String>) {
        this.name = value
    }

    /**
     * @param value Port used by the container.
     */
    @JvmName("qnecdjphxjvcxebs")
    public suspend fun port(`value`: Output<Int>) {
        this.port = value
    }

    /**
     * @param value The name of the endpoint.
     */
    @JvmName("ralenppabgvtkbhq")
    public suspend fun name(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.name = mapped
    }

    /**
     * @param value Port used by the container.
     */
    @JvmName("dwobxfwpfrnhkplw")
    public suspend fun port(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.port = mapped
    }

    internal fun build(): EndpointPropertiesArgs = EndpointPropertiesArgs(
        name = name ?: throw PulumiNullFieldException("name"),
        port = port,
    )
}
