@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.servicefabricmesh.kotlin.inputs

import com.pulumi.azurenative.servicefabricmesh.inputs.GetSecretPlainArgs.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property resourceGroupName Azure resource group name
 * @property secretResourceName The name of the secret resource.
 */
public data class GetSecretPlainArgs(
    public val resourceGroupName: String,
    public val secretResourceName: String,
) : ConvertibleToJava<com.pulumi.azurenative.servicefabricmesh.inputs.GetSecretPlainArgs> {
    override fun toJava(): com.pulumi.azurenative.servicefabricmesh.inputs.GetSecretPlainArgs =
        com.pulumi.azurenative.servicefabricmesh.inputs.GetSecretPlainArgs.builder()
            .resourceGroupName(resourceGroupName.let({ args0 -> args0 }))
            .secretResourceName(secretResourceName.let({ args0 -> args0 })).build()
}

/**
 * Builder for [GetSecretPlainArgs].
 */
@PulumiTagMarker
public class GetSecretPlainArgsBuilder internal constructor() {
    private var resourceGroupName: String? = null

    private var secretResourceName: String? = null

    /**
     * @param value Azure resource group name
     */
    @JvmName("frkyqpvwcrhlkigj")
    public suspend fun resourceGroupName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.resourceGroupName = mapped
    }

    /**
     * @param value The name of the secret resource.
     */
    @JvmName("xmfhlkiwdiuoyhwj")
    public suspend fun secretResourceName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.secretResourceName = mapped
    }

    internal fun build(): GetSecretPlainArgs = GetSecretPlainArgs(
        resourceGroupName = resourceGroupName ?: throw PulumiNullFieldException("resourceGroupName"),
        secretResourceName = secretResourceName ?: throw PulumiNullFieldException("secretResourceName"),
    )
}
