@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.servicefabricmesh.kotlin.inputs

import com.pulumi.azurenative.servicefabricmesh.inputs.ReliableCollectionsRefArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * Specifying this parameter adds support for reliable collections
 * @property doNotPersistState False (the default) if ReliableCollections state is persisted to disk as usual. True if you do not want to persist state, in which case replication is still enabled and you can use ReliableCollections as distributed cache.
 * @property name Name of ReliableCollection resource. Right now it's not used and you can use any string.
 */
public data class ReliableCollectionsRefArgs(
    public val doNotPersistState: Output<Boolean>? = null,
    public val name: Output<String>,
) : ConvertibleToJava<com.pulumi.azurenative.servicefabricmesh.inputs.ReliableCollectionsRefArgs> {
    override fun toJava(): com.pulumi.azurenative.servicefabricmesh.inputs.ReliableCollectionsRefArgs = com.pulumi.azurenative.servicefabricmesh.inputs.ReliableCollectionsRefArgs.builder()
        .doNotPersistState(doNotPersistState?.applyValue({ args0 -> args0 }))
        .name(name.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [ReliableCollectionsRefArgs].
 */
@PulumiTagMarker
public class ReliableCollectionsRefArgsBuilder internal constructor() {
    private var doNotPersistState: Output<Boolean>? = null

    private var name: Output<String>? = null

    /**
     * @param value False (the default) if ReliableCollections state is persisted to disk as usual. True if you do not want to persist state, in which case replication is still enabled and you can use ReliableCollections as distributed cache.
     */
    @JvmName("byvavqfoyeebycrv")
    public suspend fun doNotPersistState(`value`: Output<Boolean>) {
        this.doNotPersistState = value
    }

    /**
     * @param value Name of ReliableCollection resource. Right now it's not used and you can use any string.
     */
    @JvmName("bybnibagqngbtjkr")
    public suspend fun name(`value`: Output<String>) {
        this.name = value
    }

    /**
     * @param value False (the default) if ReliableCollections state is persisted to disk as usual. True if you do not want to persist state, in which case replication is still enabled and you can use ReliableCollections as distributed cache.
     */
    @JvmName("slcjbjjtpimhwssd")
    public suspend fun doNotPersistState(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.doNotPersistState = mapped
    }

    /**
     * @param value Name of ReliableCollection resource. Right now it's not used and you can use any string.
     */
    @JvmName("klpjjrwdyrykuiav")
    public suspend fun name(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.name = mapped
    }

    internal fun build(): ReliableCollectionsRefArgs = ReliableCollectionsRefArgs(
        doNotPersistState = doNotPersistState,
        name = name ?: throw PulumiNullFieldException("name"),
    )
}
