@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.servicefabricmesh.kotlin.inputs

import com.pulumi.azurenative.servicefabricmesh.inputs.ServiceResourceDescriptionArgs.builder
import com.pulumi.azurenative.servicefabricmesh.kotlin.enums.OperatingSystemType
import com.pulumi.core.Either
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 * This type describes a service resource.
 * @property autoScalingPolicies Auto scaling policies
 * @property codePackages Describes the set of code packages that forms the service. A code package describes the container and the properties for running it. All the code packages are started together on the same host and share the same context (network, process etc.).
 * @property description User readable description of the service.
 * @property diagnostics Reference to sinks in DiagnosticsDescription.
 * @property name The name of the resource
 * @property networkRefs The names of the private networks that this service needs to be part of.
 * @property osType The operation system required by the code in service.
 * @property replicaCount The number of replicas of the service to create. Defaults to 1 if not specified.
 */
public data class ServiceResourceDescriptionArgs(
    public val autoScalingPolicies: Output<List<AutoScalingPolicyArgs>>? = null,
    public val codePackages: Output<List<ContainerCodePackagePropertiesArgs>>,
    public val description: Output<String>? = null,
    public val diagnostics: Output<DiagnosticsRefArgs>? = null,
    public val name: Output<String>? = null,
    public val networkRefs: Output<List<NetworkRefArgs>>? = null,
    public val osType: Output<Either<String, OperatingSystemType>>,
    public val replicaCount: Output<Int>? = null,
) :
    ConvertibleToJava<com.pulumi.azurenative.servicefabricmesh.inputs.ServiceResourceDescriptionArgs> {
    override fun toJava(): com.pulumi.azurenative.servicefabricmesh.inputs.ServiceResourceDescriptionArgs =
        com.pulumi.azurenative.servicefabricmesh.inputs.ServiceResourceDescriptionArgs.builder()
            .autoScalingPolicies(
                autoScalingPolicies?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 -> args0.toJava() })
                    })
                }),
            )
            .codePackages(
                codePackages.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 ->
                            args0.toJava()
                        })
                    })
                }),
            )
            .description(description?.applyValue({ args0 -> args0 }))
            .diagnostics(diagnostics?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .name(name?.applyValue({ args0 -> args0 }))
            .networkRefs(
                networkRefs?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 ->
                            args0.toJava()
                        })
                    })
                }),
            )
            .osType(
                osType.applyValue({ args0 ->
                    args0.transform({ args0 -> args0 }, { args0 ->
                        args0.let({ args0 -> args0.toJava() })
                    })
                }),
            )
            .replicaCount(replicaCount?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [ServiceResourceDescriptionArgs].
 */
@PulumiTagMarker
public class ServiceResourceDescriptionArgsBuilder internal constructor() {
    private var autoScalingPolicies: Output<List<AutoScalingPolicyArgs>>? = null

    private var codePackages: Output<List<ContainerCodePackagePropertiesArgs>>? = null

    private var description: Output<String>? = null

    private var diagnostics: Output<DiagnosticsRefArgs>? = null

    private var name: Output<String>? = null

    private var networkRefs: Output<List<NetworkRefArgs>>? = null

    private var osType: Output<Either<String, OperatingSystemType>>? = null

    private var replicaCount: Output<Int>? = null

    /**
     * @param value Auto scaling policies
     */
    @JvmName("tmgadjfxapsceleh")
    public suspend fun autoScalingPolicies(`value`: Output<List<AutoScalingPolicyArgs>>) {
        this.autoScalingPolicies = value
    }

    @JvmName("uohevhfouyeoxyrm")
    public suspend fun autoScalingPolicies(vararg values: Output<AutoScalingPolicyArgs>) {
        this.autoScalingPolicies = Output.all(values.asList())
    }

    /**
     * @param values Auto scaling policies
     */
    @JvmName("ihdnverxyfnwporq")
    public suspend fun autoScalingPolicies(values: List<Output<AutoScalingPolicyArgs>>) {
        this.autoScalingPolicies = Output.all(values)
    }

    /**
     * @param value Describes the set of code packages that forms the service. A code package describes the container and the properties for running it. All the code packages are started together on the same host and share the same context (network, process etc.).
     */
    @JvmName("unrqbjmuwwrjmdmn")
    public suspend fun codePackages(`value`: Output<List<ContainerCodePackagePropertiesArgs>>) {
        this.codePackages = value
    }

    @JvmName("ddajkaruinymsfps")
    public suspend fun codePackages(vararg values: Output<ContainerCodePackagePropertiesArgs>) {
        this.codePackages = Output.all(values.asList())
    }

    /**
     * @param values Describes the set of code packages that forms the service. A code package describes the container and the properties for running it. All the code packages are started together on the same host and share the same context (network, process etc.).
     */
    @JvmName("iympboogrhapsijq")
    public suspend fun codePackages(values: List<Output<ContainerCodePackagePropertiesArgs>>) {
        this.codePackages = Output.all(values)
    }

    /**
     * @param value User readable description of the service.
     */
    @JvmName("arcbfxooftvuhfid")
    public suspend fun description(`value`: Output<String>) {
        this.description = value
    }

    /**
     * @param value Reference to sinks in DiagnosticsDescription.
     */
    @JvmName("xcsqfrivobjqixin")
    public suspend fun diagnostics(`value`: Output<DiagnosticsRefArgs>) {
        this.diagnostics = value
    }

    /**
     * @param value The name of the resource
     */
    @JvmName("cjvhkplglwkbasdd")
    public suspend fun name(`value`: Output<String>) {
        this.name = value
    }

    /**
     * @param value The names of the private networks that this service needs to be part of.
     */
    @JvmName("vrxwsqoghomlfeaj")
    public suspend fun networkRefs(`value`: Output<List<NetworkRefArgs>>) {
        this.networkRefs = value
    }

    @JvmName("ndhjtnotlkcmtywo")
    public suspend fun networkRefs(vararg values: Output<NetworkRefArgs>) {
        this.networkRefs = Output.all(values.asList())
    }

    /**
     * @param values The names of the private networks that this service needs to be part of.
     */
    @JvmName("ieijlyktgjdeudbu")
    public suspend fun networkRefs(values: List<Output<NetworkRefArgs>>) {
        this.networkRefs = Output.all(values)
    }

    /**
     * @param value The operation system required by the code in service.
     */
    @JvmName("neinbqvevkotayjs")
    public suspend fun osType(`value`: Output<Either<String, OperatingSystemType>>) {
        this.osType = value
    }

    /**
     * @param value The number of replicas of the service to create. Defaults to 1 if not specified.
     */
    @JvmName("ipirrxytjfaydbql")
    public suspend fun replicaCount(`value`: Output<Int>) {
        this.replicaCount = value
    }

    /**
     * @param value Auto scaling policies
     */
    @JvmName("qcunvinrbccudqsc")
    public suspend fun autoScalingPolicies(`value`: List<AutoScalingPolicyArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.autoScalingPolicies = mapped
    }

    /**
     * @param argument Auto scaling policies
     */
    @JvmName("bcmisdpfhudtcrbi")
    public suspend fun autoScalingPolicies(argument: List<suspend AutoScalingPolicyArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            AutoScalingPolicyArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.autoScalingPolicies = mapped
    }

    /**
     * @param argument Auto scaling policies
     */
    @JvmName("dgtkvblemfqarscq")
    public suspend fun autoScalingPolicies(vararg argument: suspend AutoScalingPolicyArgsBuilder.() -> Unit) {
        val toBeMapped = argument.toList().map {
            AutoScalingPolicyArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.autoScalingPolicies = mapped
    }

    /**
     * @param argument Auto scaling policies
     */
    @JvmName("xapbutqeiionyyyw")
    public suspend fun autoScalingPolicies(argument: suspend AutoScalingPolicyArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(AutoScalingPolicyArgsBuilder().applySuspend { argument() }.build())
        val mapped = of(toBeMapped)
        this.autoScalingPolicies = mapped
    }

    /**
     * @param values Auto scaling policies
     */
    @JvmName("mqkbfdfsjnyqmiud")
    public suspend fun autoScalingPolicies(vararg values: AutoScalingPolicyArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.autoScalingPolicies = mapped
    }

    /**
     * @param value Describes the set of code packages that forms the service. A code package describes the container and the properties for running it. All the code packages are started together on the same host and share the same context (network, process etc.).
     */
    @JvmName("vdysjgugaxouxdit")
    public suspend fun codePackages(`value`: List<ContainerCodePackagePropertiesArgs>) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.codePackages = mapped
    }

    /**
     * @param argument Describes the set of code packages that forms the service. A code package describes the container and the properties for running it. All the code packages are started together on the same host and share the same context (network, process etc.).
     */
    @JvmName("jouwivsmlefcwfop")
    public suspend fun codePackages(argument: List<suspend ContainerCodePackagePropertiesArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            ContainerCodePackagePropertiesArgsBuilder().applySuspend { it() }.build()
        }
        val mapped = of(toBeMapped)
        this.codePackages = mapped
    }

    /**
     * @param argument Describes the set of code packages that forms the service. A code package describes the container and the properties for running it. All the code packages are started together on the same host and share the same context (network, process etc.).
     */
    @JvmName("orgvuvvbwtlaoitn")
    public suspend fun codePackages(vararg argument: suspend ContainerCodePackagePropertiesArgsBuilder.() -> Unit) {
        val toBeMapped = argument.toList().map {
            ContainerCodePackagePropertiesArgsBuilder().applySuspend { it() }.build()
        }
        val mapped = of(toBeMapped)
        this.codePackages = mapped
    }

    /**
     * @param argument Describes the set of code packages that forms the service. A code package describes the container and the properties for running it. All the code packages are started together on the same host and share the same context (network, process etc.).
     */
    @JvmName("thyvlshvnvusbvbb")
    public suspend fun codePackages(argument: suspend ContainerCodePackagePropertiesArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(
            ContainerCodePackagePropertiesArgsBuilder().applySuspend {
                argument()
            }.build(),
        )
        val mapped = of(toBeMapped)
        this.codePackages = mapped
    }

    /**
     * @param values Describes the set of code packages that forms the service. A code package describes the container and the properties for running it. All the code packages are started together on the same host and share the same context (network, process etc.).
     */
    @JvmName("knqifgwgwjxlpfkk")
    public suspend fun codePackages(vararg values: ContainerCodePackagePropertiesArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.codePackages = mapped
    }

    /**
     * @param value User readable description of the service.
     */
    @JvmName("vnsaxxcnqdpohffh")
    public suspend fun description(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.description = mapped
    }

    /**
     * @param value Reference to sinks in DiagnosticsDescription.
     */
    @JvmName("meshdrjdjnymhdyl")
    public suspend fun diagnostics(`value`: DiagnosticsRefArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.diagnostics = mapped
    }

    /**
     * @param argument Reference to sinks in DiagnosticsDescription.
     */
    @JvmName("gjvnbupgeyhibeng")
    public suspend fun diagnostics(argument: suspend DiagnosticsRefArgsBuilder.() -> Unit) {
        val toBeMapped = DiagnosticsRefArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.diagnostics = mapped
    }

    /**
     * @param value The name of the resource
     */
    @JvmName("kfbpcodfaiyuyvjc")
    public suspend fun name(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.name = mapped
    }

    /**
     * @param value The names of the private networks that this service needs to be part of.
     */
    @JvmName("cocyaoktdyejtyxe")
    public suspend fun networkRefs(`value`: List<NetworkRefArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.networkRefs = mapped
    }

    /**
     * @param argument The names of the private networks that this service needs to be part of.
     */
    @JvmName("hthlyaitaajxurjt")
    public suspend fun networkRefs(argument: List<suspend NetworkRefArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map { NetworkRefArgsBuilder().applySuspend { it() }.build() }
        val mapped = of(toBeMapped)
        this.networkRefs = mapped
    }

    /**
     * @param argument The names of the private networks that this service needs to be part of.
     */
    @JvmName("ucapsawwuonsjsed")
    public suspend fun networkRefs(vararg argument: suspend NetworkRefArgsBuilder.() -> Unit) {
        val toBeMapped = argument.toList().map { NetworkRefArgsBuilder().applySuspend { it() }.build() }
        val mapped = of(toBeMapped)
        this.networkRefs = mapped
    }

    /**
     * @param argument The names of the private networks that this service needs to be part of.
     */
    @JvmName("xprdwpjupkklnsfw")
    public suspend fun networkRefs(argument: suspend NetworkRefArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(NetworkRefArgsBuilder().applySuspend { argument() }.build())
        val mapped = of(toBeMapped)
        this.networkRefs = mapped
    }

    /**
     * @param values The names of the private networks that this service needs to be part of.
     */
    @JvmName("pfgkvkhaydwwmjfd")
    public suspend fun networkRefs(vararg values: NetworkRefArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.networkRefs = mapped
    }

    /**
     * @param value The operation system required by the code in service.
     */
    @JvmName("urgkpakhehehwrfm")
    public suspend fun osType(`value`: Either<String, OperatingSystemType>) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.osType = mapped
    }

    /**
     * @param value The operation system required by the code in service.
     */
    @JvmName("gaiotxxpypoahwcv")
    public fun osType(`value`: String) {
        val toBeMapped = Either.ofLeft<String, OperatingSystemType>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.osType = mapped
    }

    /**
     * @param value The operation system required by the code in service.
     */
    @JvmName("pyihghhaenqshbxx")
    public fun osType(`value`: OperatingSystemType) {
        val toBeMapped = Either.ofRight<String, OperatingSystemType>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.osType = mapped
    }

    /**
     * @param value The number of replicas of the service to create. Defaults to 1 if not specified.
     */
    @JvmName("pvvrmqycqanbjcny")
    public suspend fun replicaCount(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.replicaCount = mapped
    }

    internal fun build(): ServiceResourceDescriptionArgs = ServiceResourceDescriptionArgs(
        autoScalingPolicies = autoScalingPolicies,
        codePackages = codePackages ?: throw PulumiNullFieldException("codePackages"),
        description = description,
        diagnostics = diagnostics,
        name = name,
        networkRefs = networkRefs,
        osType = osType ?: throw PulumiNullFieldException("osType"),
        replicaCount = replicaCount,
    )
}
