@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.servicefabricmesh.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 * Describes the auto scaling policy
 * @property mechanism The mechanism that is used to scale when auto scaling operation is invoked.
 * @property name The name of the auto scaling policy.
 * @property trigger Determines when auto scaling operation will be invoked.
 */
public data class AutoScalingPolicyResponse(
    public val mechanism: AddRemoveReplicaScalingMechanismResponse,
    public val name: String,
    public val trigger: AverageLoadScalingTriggerResponse,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.servicefabricmesh.outputs.AutoScalingPolicyResponse): AutoScalingPolicyResponse = AutoScalingPolicyResponse(
            mechanism = javaType.mechanism().let({ args0 ->
                com.pulumi.azurenative.servicefabricmesh.kotlin.outputs.AddRemoveReplicaScalingMechanismResponse.Companion.toKotlin(args0)
            }),
            name = javaType.name(),
            trigger = javaType.trigger().let({ args0 ->
                com.pulumi.azurenative.servicefabricmesh.kotlin.outputs.AverageLoadScalingTriggerResponse.Companion.toKotlin(args0)
            }),
        )
    }
}
