@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.servicefabricmesh.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 * Describes the resource that is used for triggering auto scaling.
 * @property kind Enumerates the metrics that are used for triggering auto scaling.
 * Expected value is 'Resource'.
 * @property name Name of the resource.
 */
public data class AutoScalingResourceMetricResponse(
    public val kind: String,
    public val name: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.servicefabricmesh.outputs.AutoScalingResourceMetricResponse): AutoScalingResourceMetricResponse = AutoScalingResourceMetricResponse(
            kind = javaType.kind(),
            name = javaType.name(),
        )
    }
}
