@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.servicefabricmesh.kotlin.outputs

import kotlin.String
import kotlin.Suppress
import kotlin.collections.List

/**
 * Describes a container and its runtime properties.
 * @property commands Command array to execute within the container in exec form.
 * @property diagnostics Reference to sinks in DiagnosticsDescription.
 * @property endpoints The endpoints exposed by this container.
 * @property entrypoint Override for the default entry point in the container.
 * @property environmentVariables The environment variables to set in this container
 * @property image The Container image to use.
 * @property imageRegistryCredential Image registry credential.
 * @property instanceView Runtime information of a container instance.
 * @property labels The labels to set in this container.
 * @property name The name of the code package.
 * @property reliableCollectionsRefs A list of ReliableCollection resources used by this particular code package. Please refer to ReliableCollectionsRef for more details.
 * @property resources The resources required by this container.
 * @property settings The settings to set in this container. The setting file path can be fetched from environment variable "Fabric_SettingPath". The path for Windows container is "C:\\secrets". The path for Linux container is "/var/secrets".
 * @property volumeRefs Volumes to be attached to the container. The lifetime of these volumes is independent of the application's lifetime.
 * @property volumes Volumes to be attached to the container. The lifetime of these volumes is scoped to the application's lifetime.
 */
public data class ContainerCodePackagePropertiesResponse(
    public val commands: List<String>? = null,
    public val diagnostics: DiagnosticsRefResponse? = null,
    public val endpoints: List<EndpointPropertiesResponse>? = null,
    public val entrypoint: String? = null,
    public val environmentVariables: List<EnvironmentVariableResponse>? = null,
    public val image: String,
    public val imageRegistryCredential: ImageRegistryCredentialResponse? = null,
    public val instanceView: ContainerInstanceViewResponse,
    public val labels: List<ContainerLabelResponse>? = null,
    public val name: String,
    public val reliableCollectionsRefs: List<ReliableCollectionsRefResponse>? = null,
    public val resources: ResourceRequirementsResponse,
    public val settings: List<SettingResponse>? = null,
    public val volumeRefs: List<VolumeReferenceResponse>? = null,
    public val volumes: List<ApplicationScopedVolumeResponse>? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.servicefabricmesh.outputs.ContainerCodePackagePropertiesResponse): ContainerCodePackagePropertiesResponse = ContainerCodePackagePropertiesResponse(
            commands = javaType.commands().map({ args0 -> args0 }),
            diagnostics = javaType.diagnostics().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.servicefabricmesh.kotlin.outputs.DiagnosticsRefResponse.Companion.toKotlin(args0)
                })
            }).orElse(null),
            endpoints = javaType.endpoints().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.servicefabricmesh.kotlin.outputs.EndpointPropertiesResponse.Companion.toKotlin(args0)
                })
            }),
            entrypoint = javaType.entrypoint().map({ args0 -> args0 }).orElse(null),
            environmentVariables = javaType.environmentVariables().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.servicefabricmesh.kotlin.outputs.EnvironmentVariableResponse.Companion.toKotlin(args0)
                })
            }),
            image = javaType.image(),
            imageRegistryCredential = javaType.imageRegistryCredential().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.servicefabricmesh.kotlin.outputs.ImageRegistryCredentialResponse.Companion.toKotlin(args0)
                })
            }).orElse(null),
            instanceView = javaType.instanceView().let({ args0 ->
                com.pulumi.azurenative.servicefabricmesh.kotlin.outputs.ContainerInstanceViewResponse.Companion.toKotlin(args0)
            }),
            labels = javaType.labels().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.servicefabricmesh.kotlin.outputs.ContainerLabelResponse.Companion.toKotlin(args0)
                })
            }),
            name = javaType.name(),
            reliableCollectionsRefs = javaType.reliableCollectionsRefs().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.servicefabricmesh.kotlin.outputs.ReliableCollectionsRefResponse.Companion.toKotlin(args0)
                })
            }),
            resources = javaType.resources().let({ args0 ->
                com.pulumi.azurenative.servicefabricmesh.kotlin.outputs.ResourceRequirementsResponse.Companion.toKotlin(args0)
            }),
            settings = javaType.settings().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.servicefabricmesh.kotlin.outputs.SettingResponse.Companion.toKotlin(args0)
                })
            }),
            volumeRefs = javaType.volumeRefs().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.servicefabricmesh.kotlin.outputs.VolumeReferenceResponse.Companion.toKotlin(args0)
                })
            }),
            volumes = javaType.volumes().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.servicefabricmesh.kotlin.outputs.ApplicationScopedVolumeResponse.Companion.toKotlin(args0)
                })
            }),
        )
    }
}
