@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.servicefabricmesh.kotlin.outputs

import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List

/**
 * Describes the diagnostics options available
 * @property defaultSinkRefs The sinks to be used if diagnostics is enabled. Sink choices can be overridden at the service and code package level.
 * @property enabled Status of whether or not sinks are enabled.
 * @property sinks List of supported sinks that can be referenced.
 */
public data class DiagnosticsDescriptionResponse(
    public val defaultSinkRefs: List<String>? = null,
    public val enabled: Boolean? = null,
    public val sinks: List<AzureInternalMonitoringPipelineSinkDescriptionResponse>? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.servicefabricmesh.outputs.DiagnosticsDescriptionResponse): DiagnosticsDescriptionResponse = DiagnosticsDescriptionResponse(
            defaultSinkRefs = javaType.defaultSinkRefs().map({ args0 -> args0 }),
            enabled = javaType.enabled().map({ args0 -> args0 }).orElse(null),
            sinks = javaType.sinks().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.servicefabricmesh.kotlin.outputs.AzureInternalMonitoringPipelineSinkDescriptionResponse.Companion.toKotlin(args0)
                })
            }),
        )
    }
}
