@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.servicefabricmesh.kotlin.outputs

import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List

/**
 * Reference to sinks in DiagnosticsDescription.
 * @property enabled Status of whether or not sinks are enabled.
 * @property sinkRefs List of sinks to be used if enabled. References the list of sinks in DiagnosticsDescription.
 */
public data class DiagnosticsRefResponse(
    public val enabled: Boolean? = null,
    public val sinkRefs: List<String>? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.servicefabricmesh.outputs.DiagnosticsRefResponse): DiagnosticsRefResponse = DiagnosticsRefResponse(
            enabled = javaType.enabled().map({ args0 -> args0 }).orElse(null),
            sinkRefs = javaType.sinkRefs().map({ args0 -> args0 }),
        )
    }
}
