@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.servicefabricmesh.kotlin.outputs

import kotlin.Int
import kotlin.String
import kotlin.Suppress

/**
 * Describes a container endpoint.
 * @property name The name of the endpoint.
 * @property port Port used by the container.
 */
public data class EndpointPropertiesResponse(
    public val name: String,
    public val port: Int? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.servicefabricmesh.outputs.EndpointPropertiesResponse): EndpointPropertiesResponse = EndpointPropertiesResponse(
            name = javaType.name(),
            port = javaType.port().map({ args0 -> args0 }).orElse(null),
        )
    }
}
