@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.servicefabricmesh.kotlin.outputs

import kotlin.String
import kotlin.Suppress
import kotlin.collections.List
import kotlin.collections.Map

/**
 * This type describes a gateway resource.
 * @property description User readable description of the gateway.
 * @property destinationNetwork Network that the Application is using.
 * @property http Configuration for http connectivity for this gateway.
 * @property id Fully qualified identifier for the resource. Ex - /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}
 * @property ipAddress IP address of the gateway. This is populated in the response and is ignored for incoming requests.
 * @property location The geo-location where the resource lives
 * @property name The name of the resource
 * @property provisioningState State of the resource.
 * @property sourceNetwork Network the gateway should listen on for requests.
 * @property status Status of the resource.
 * @property statusDetails Gives additional information about the current status of the gateway.
 * @property tags Resource tags.
 * @property tcp Configuration for tcp connectivity for this gateway.
 * @property type The type of the resource. Ex- Microsoft.Compute/virtualMachines or Microsoft.Storage/storageAccounts.
 */
public data class GetGatewayResult(
    public val description: String? = null,
    public val destinationNetwork: NetworkRefResponse,
    public val http: List<HttpConfigResponse>? = null,
    public val id: String,
    public val ipAddress: String,
    public val location: String,
    public val name: String,
    public val provisioningState: String,
    public val sourceNetwork: NetworkRefResponse,
    public val status: String,
    public val statusDetails: String,
    public val tags: Map<String, String>? = null,
    public val tcp: List<TcpConfigResponse>? = null,
    public val type: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.servicefabricmesh.outputs.GetGatewayResult): GetGatewayResult = GetGatewayResult(
            description = javaType.description().map({ args0 -> args0 }).orElse(null),
            destinationNetwork = javaType.destinationNetwork().let({ args0 ->
                com.pulumi.azurenative.servicefabricmesh.kotlin.outputs.NetworkRefResponse.Companion.toKotlin(args0)
            }),
            http = javaType.http().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.servicefabricmesh.kotlin.outputs.HttpConfigResponse.Companion.toKotlin(args0)
                })
            }),
            id = javaType.id(),
            ipAddress = javaType.ipAddress(),
            location = javaType.location(),
            name = javaType.name(),
            provisioningState = javaType.provisioningState(),
            sourceNetwork = javaType.sourceNetwork().let({ args0 ->
                com.pulumi.azurenative.servicefabricmesh.kotlin.outputs.NetworkRefResponse.Companion.toKotlin(args0)
            }),
            status = javaType.status(),
            statusDetails = javaType.statusDetails(),
            tags = javaType.tags().map({ args0 -> args0.key.to(args0.value) }).toMap(),
            tcp = javaType.tcp().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.servicefabricmesh.kotlin.outputs.TcpConfigResponse.Companion.toKotlin(args0)
                })
            }),
            type = javaType.type(),
        )
    }
}
