@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.servicefabricmesh.kotlin.outputs

import kotlin.String
import kotlin.Suppress
import kotlin.collections.Map

/**
 * This type describes a volume resource.
 * @property azureFileParameters This type describes a volume provided by an Azure Files file share.
 * @property description User readable description of the volume.
 * @property id Fully qualified identifier for the resource. Ex - /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}
 * @property location The geo-location where the resource lives
 * @property name The name of the resource
 * @property provider Provider of the volume.
 * @property provisioningState State of the resource.
 * @property status Status of the volume.
 * @property statusDetails Gives additional information about the current status of the volume.
 * @property tags Resource tags.
 * @property type The type of the resource. Ex- Microsoft.Compute/virtualMachines or Microsoft.Storage/storageAccounts.
 */
public data class GetVolumeResult(
    public val azureFileParameters: VolumeProviderParametersAzureFileResponse? = null,
    public val description: String? = null,
    public val id: String,
    public val location: String,
    public val name: String,
    public val provider: String,
    public val provisioningState: String,
    public val status: String,
    public val statusDetails: String,
    public val tags: Map<String, String>? = null,
    public val type: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.servicefabricmesh.outputs.GetVolumeResult): GetVolumeResult = GetVolumeResult(
            azureFileParameters = javaType.azureFileParameters().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.servicefabricmesh.kotlin.outputs.VolumeProviderParametersAzureFileResponse.Companion.toKotlin(args0)
                })
            }).orElse(null),
            description = javaType.description().map({ args0 -> args0 }).orElse(null),
            id = javaType.id(),
            location = javaType.location(),
            name = javaType.name(),
            provider = javaType.provider(),
            provisioningState = javaType.provisioningState(),
            status = javaType.status(),
            statusDetails = javaType.statusDetails(),
            tags = javaType.tags().map({ args0 -> args0.key.to(args0.value) }).toMap(),
            type = javaType.type(),
        )
    }
}
