@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.servicefabricmesh.kotlin.outputs

import kotlin.String
import kotlin.Suppress
import kotlin.collections.List

/**
 * Describes the hostname properties for http routing.
 * @property name http hostname config name.
 * @property routes Route information to use for routing. Routes are processed in the order they are specified. Specify routes that are more specific before routes that can handle general cases.
 */
public data class HttpHostConfigResponse(
    public val name: String,
    public val routes: List<HttpRouteConfigResponse>,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.servicefabricmesh.outputs.HttpHostConfigResponse): HttpHostConfigResponse = HttpHostConfigResponse(
            name = javaType.name(),
            routes = javaType.routes().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.servicefabricmesh.kotlin.outputs.HttpRouteConfigResponse.Companion.toKotlin(args0)
                })
            }),
        )
    }
}
