@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.servicefabricmesh.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 * Describes the hostname properties for http routing.
 * @property destination Describes destination endpoint for routing traffic.
 * @property match Describes a rule for http route matching.
 * @property name http route name.
 */
public data class HttpRouteConfigResponse(
    public val destination: GatewayDestinationResponse,
    public val match: HttpRouteMatchRuleResponse,
    public val name: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.servicefabricmesh.outputs.HttpRouteConfigResponse): HttpRouteConfigResponse = HttpRouteConfigResponse(
            destination = javaType.destination().let({ args0 ->
                com.pulumi.azurenative.servicefabricmesh.kotlin.outputs.GatewayDestinationResponse.Companion.toKotlin(args0)
            }),
            match = javaType.match().let({ args0 ->
                com.pulumi.azurenative.servicefabricmesh.kotlin.outputs.HttpRouteMatchRuleResponse.Companion.toKotlin(args0)
            }),
            name = javaType.name(),
        )
    }
}
